/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.custom;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.custom.Client;
import cn.kinyun.scrm.weixin.sdk.entity.custom.ClientList;
import cn.kinyun.scrm.weixin.sdk.entity.custom.Servant;
import cn.kinyun.scrm.weixin.sdk.entity.custom.WaitCase;
import cn.kinyun.scrm.weixin.sdk.entity.custom.WaitCaseList;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WxCustomSessionAPI {
    private static final Logger log = LoggerFactory.getLogger(WxCustomSessionAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.custom.kfsession.create}")
    private String wxCustomSessionCreate;
    @Value(value="${wx.custom.kfsession.close}")
    private String wxCustomSessionClose;
    @Value(value="${wx.custom.kfsession.getsession}")
    private String wxCustomSessionGet;
    @Value(value="${wx.custom.kfsession.getsessionlist}")
    private String wxCustomSessionGetList;
    @Value(value="${wx.custom.kfsession.getwaitcase}")
    private String wxCustomSessionGetWaitCase;

    public void create(@NonNull String accessToken, @NonNull String kfAccount, @NonNull String openId) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (kfAccount == null) {
            throw new NullPointerException("kfAccount is marked non-null but is null");
        }
        if (openId == null) {
            throw new NullPointerException("openId is marked non-null but is null");
        }
        log.info("create session between kf_account={} and openid={}", (Object)kfAccount, (Object)openId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("kf_account", kfAccount);
        params.put("openid", openId);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = MessageFormat.format(this.wxCustomSessionCreate, accessToken);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ErrorCode.class, new Object[0]);
        WeixinException.isSuccess((ErrorCode)response.getBody());
    }

    public void close(@NonNull String accessToken, @NonNull String kfAccount, @NonNull String openId) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (kfAccount == null) {
            throw new NullPointerException("kfAccount is marked non-null but is null");
        }
        if (openId == null) {
            throw new NullPointerException("openId is marked non-null but is null");
        }
        log.info("close kfsession between kf_account={} and openid={}", (Object)kfAccount, (Object)openId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("kf_account", kfAccount);
        params.put("openid", openId);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = MessageFormat.format(this.wxCustomSessionClose, accessToken);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ErrorCode.class, new Object[0]);
        WeixinException.isSuccess((ErrorCode)response.getBody());
    }

    public Servant getSession(@NonNull String accessToken, @NonNull String openId) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (openId == null) {
            throw new NullPointerException("openId is marked non-null but is null");
        }
        log.info("get session with openid={}", (Object)openId);
        String url = MessageFormat.format(this.wxCustomSessionGet, accessToken, openId);
        ResponseEntity response = this.restTemplate.getForEntity(url, Servant.class, new Object[0]);
        Servant result = (Servant)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public List<Client> getSessionList(@NonNull String accessToken, @NonNull String kfAccount) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (kfAccount == null) {
            throw new NullPointerException("kfAccount is marked non-null but is null");
        }
        log.info("get session list with kf_account={}", (Object)kfAccount);
        String url = MessageFormat.format(this.wxCustomSessionGetList, accessToken, kfAccount);
        ResponseEntity response = this.restTemplate.getForEntity(url, ClientList.class, new Object[0]);
        ClientList result = (ClientList)response.getBody();
        WeixinException.isSuccess(result);
        return result.getList();
    }

    public List<WaitCase> getWaitCase(@NonNull String accessToken) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("get wait case");
        String url = MessageFormat.format(this.wxCustomSessionGetWaitCase, accessToken);
        ResponseEntity response = this.restTemplate.getForEntity(url, WaitCaseList.class, new Object[0]);
        WaitCaseList result = (WaitCaseList)response.getBody();
        WeixinException.isSuccess(result);
        return result.getList();
    }
}

