/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.custom;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.BaseRespMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.ImageMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.MenuMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.MiniProgramMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.MpNewsMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.MusicMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.NewsMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.TextMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.VideoMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.VoiceMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.WxCardMsg;
import cn.kinyun.scrm.weixin.sdk.enums.WxMsgType;
import cn.kinyun.scrm.weixin.sdk.enums.custom.WxTypingStatus;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.sdk.utils.JsonUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.HashMap;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WxCustomMsgAPI {
    private static final Logger log = LoggerFactory.getLogger(WxCustomMsgAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.message.custom.send}")
    private String wxMessageCustomSend;
    @Value(value="${wx.message.custom.typing}")
    private String wxMessageCustomTyping;

    public void sendCustomMsg(@NonNull String accessToken, @NonNull BaseRespMsg message, String kfaccount) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        log.info("send custom msg with message={}, kfaccount={}", (Object)message, (Object)kfaccount);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{message.getToUserName()}), (Object)"\u63a5\u53d7\u8005\u7684openid\u4e3a\u7a7a");
        this.checkCustomMsgType(message);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("touser", message.getToUserName());
        params.put("msgtype", message.getMsgType());
        params.put(message.getMsgType(), message);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{kfaccount})) {
            HashMap customService = Maps.newHashMap();
            customService.put("kf_account", kfaccount);
            params.put("customservice", customService);
        }
        if (message.getClientMsgId() != null) {
            params.put("clientmsgid", message.getClientMsgId());
        }
        byte[] data = JsonUtil.obj2Str(params).getBytes(StandardCharsets.UTF_8);
        HttpEntity request = new HttpEntity((Object)data, (MultiValueMap)headers);
        String url = MessageFormat.format(this.wxMessageCustomSend, accessToken);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ErrorCode.class, new Object[0]);
        WeixinException.isSuccess((ErrorCode)response.getBody());
    }

    public void sendTypingStatus(@NonNull String accessToken, @NonNull String openId, @NonNull WxTypingStatus command) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (openId == null) {
            throw new NullPointerException("openId is marked non-null but is null");
        }
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        log.info("send typing status to openid={}, command={}", (Object)openId, (Object)command);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("touser", openId);
        params.put("command", command.name());
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = MessageFormat.format(this.wxMessageCustomTyping, accessToken);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ErrorCode.class, new Object[0]);
        WeixinException.isSuccess((ErrorCode)response.getBody());
    }

    private void checkCustomMsgType(@NonNull BaseRespMsg message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{message.getMsgType()}), (Object)"\u6d88\u606f\u7c7b\u578b\u4e3a\u7a7a");
        WxMsgType msgType = WxMsgType.get(message.getMsgType());
        Preconditions.checkArgument((msgType != null ? 1 : 0) != 0, (Object)"\u672a\u77e5\u7684\u6d88\u606f\u7c7b\u578b");
        switch (msgType) {
            case Text: {
                Preconditions.checkArgument((boolean)(message instanceof TextMsg), (Object)"\u6d88\u606f\u7c7b\u578b\u4e0e\u5b9e\u4f8b\u7c7b\u578b\u4e0d\u5339\u914d");
                break;
            }
            case Image: {
                Preconditions.checkArgument((boolean)(message instanceof ImageMsg), (Object)"\u6d88\u606f\u7c7b\u578b\u4e0e\u5b9e\u4f8b\u7c7b\u578b\u4e0d\u5339\u914d");
                break;
            }
            case Voice: {
                Preconditions.checkArgument((boolean)(message instanceof VoiceMsg), (Object)"\u6d88\u606f\u7c7b\u578b\u4e0e\u5b9e\u4f8b\u7c7b\u578b\u4e0d\u5339\u914d");
                break;
            }
            case Video: {
                Preconditions.checkArgument((boolean)(message instanceof VideoMsg), (Object)"\u6d88\u606f\u7c7b\u578b\u4e0e\u5b9e\u4f8b\u7c7b\u578b\u4e0d\u5339\u914d");
                break;
            }
            case Music: {
                Preconditions.checkArgument((boolean)(message instanceof MusicMsg), (Object)"\u6d88\u606f\u7c7b\u578b\u4e0e\u5b9e\u4f8b\u7c7b\u578b\u4e0d\u5339\u914d");
                break;
            }
            case News: {
                Preconditions.checkArgument((boolean)(message instanceof NewsMsg), (Object)"\u6d88\u606f\u7c7b\u578b\u4e0e\u5b9e\u4f8b\u7c7b\u578b\u4e0d\u5339\u914d");
                break;
            }
            case MpNews: {
                Preconditions.checkArgument((boolean)(message instanceof MpNewsMsg), (Object)"\u6d88\u606f\u7c7b\u578b\u4e0e\u5b9e\u4f8b\u7c7b\u578b\u4e0d\u5339\u914d");
                break;
            }
            case MsgMenu: {
                Preconditions.checkArgument((boolean)(message instanceof MenuMsg), (Object)"\u6d88\u606f\u7c7b\u578b\u4e0e\u5b9e\u4f8b\u7c7b\u578b\u4e0d\u5339\u914d");
                break;
            }
            case WxCard: {
                Preconditions.checkArgument((boolean)(message instanceof WxCardMsg), (Object)"\u6d88\u606f\u7c7b\u578b\u4e0e\u5b9e\u4f8b\u7c7b\u578b\u4e0d\u5339\u914d");
                break;
            }
            case MiniProgramPage: {
                Preconditions.checkArgument((boolean)(message instanceof MiniProgramMsg), (Object)"\u6d88\u606f\u7c7b\u578b\u4e0e\u5b9e\u4f8b\u7c7b\u578b\u4e0d\u5339\u914d");
                break;
            }
            default: {
                throw new IllegalArgumentException("\u5ba2\u670d\u6d88\u606f\u4ec5\u652f\u6301\u4e0b\u5217\u7c7b\u578b\uff1a\u6587\u672c(text), \u56fe\u7247(image), \u8bed\u97f3(voice), \u89c6\u9891(video), \u97f3\u4e50(music), \u56fe\u6587(news,mpnews), \u83dc\u5355(msgmenu), \u5361\u5238(wxcard), \u5c0f\u7a0b\u5e8f\u5361\u7247(miniprogrampage)");
            }
        }
    }
}

