/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.custom;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.custom.CustomAccount;
import cn.kinyun.scrm.weixin.sdk.entity.custom.CustomAccountList;
import cn.kinyun.scrm.weixin.sdk.entity.custom.OnlineCustomAccount;
import cn.kinyun.scrm.weixin.sdk.entity.custom.OnlineList;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WxCustomAccountAPI {
    private static final Logger log = LoggerFactory.getLogger(WxCustomAccountAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.custom.kfaccount.add}")
    private String wxCustomAccountAdd;
    @Value(value="${wx.custom.kfaccount.update")
    private String wxCustomAccountUpdate;
    @Value(value="${wx.custom.kfaccount.del")
    private String wxCustomAccountDelete;
    @Value(value="${wx.custom.kfaccount.inviteworker")
    private String wxCustomAccountInviteWorker;
    @Value(value="${wx.custom.kfaccount.uploadheadimg")
    private String wxCustomAccountUploadHeadImg;
    @Value(value="${wx.custom.kfaccount.getkflist")
    private String wxCustomAccountGetKflist;
    @Value(value="${wx.custom.kfaccount.getkflist")
    private String wxCustomAccountGetOnlineKflist;

    public void add(@NonNull String accessToken, @NonNull CustomAccount params) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        log.info("add custom account with params={}", (Object)params);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getAccount()}), (Object)"\u5ba2\u670d\u8d26\u53f7\u540d\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getNickname()}), (Object)"\u5ba2\u670d\u6635\u79f0\u4e3a\u7a7a");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = MessageFormat.format(this.wxCustomAccountAdd, accessToken);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ErrorCode.class, new Object[0]);
        WeixinException.isSuccess((ErrorCode)response.getBody());
    }

    public void update(@NonNull String accessToken, @NonNull CustomAccount params) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        log.info("update custom account with params={}", (Object)params);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getAccount()}), (Object)"\u5ba2\u670d\u8d26\u53f7\u540d\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getNickname()}), (Object)"\u5ba2\u670d\u6635\u79f0\u4e3a\u7a7a");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = MessageFormat.format(this.wxCustomAccountUpdate, accessToken);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ErrorCode.class, new Object[0]);
        WeixinException.isSuccess((ErrorCode)response.getBody());
    }

    public void delete(@NonNull String accessToken, @NonNull String kfAccount) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (kfAccount == null) {
            throw new NullPointerException("kfAccount is marked non-null but is null");
        }
        log.info("delete custom account with kf_account={}", (Object)kfAccount);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{kfAccount}), (Object)"\u5ba2\u670d\u8d26\u53f7\u540d\u4e3a\u7a7a");
        String url = MessageFormat.format(this.wxCustomAccountDelete, accessToken, kfAccount);
        ResponseEntity response = this.restTemplate.getForEntity(url, ErrorCode.class, new Object[0]);
        WeixinException.isSuccess((ErrorCode)response.getBody());
    }

    public void inviteWorker(@NonNull String accessToken, @NonNull String kfAccount, @NonNull String inviteWx) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (kfAccount == null) {
            throw new NullPointerException("kfAccount is marked non-null but is null");
        }
        if (inviteWx == null) {
            throw new NullPointerException("inviteWx is marked non-null but is null");
        }
        log.info("bind kf_account={} with invite_wx={}", (Object)kfAccount, (Object)inviteWx);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{kfAccount}), (Object)"\u5ba2\u670d\u8d26\u53f7\u540d\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{inviteWx}), (Object)"\u53d7\u9080\u5ba2\u670d\u5fae\u4fe1\u53f7\u4e3a\u7a7a");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("kf_account", kfAccount);
        params.put("invite_wx", inviteWx);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = MessageFormat.format(this.wxCustomAccountInviteWorker, accessToken);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ErrorCode.class, new Object[0]);
        WeixinException.isSuccess((ErrorCode)response.getBody());
    }

    public void uploadHeadImg(@NonNull String accessToken, @NonNull String account, @NonNull Resource media) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        log.info("upload head img with account={}, media={}", (Object)account, (Object)media);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{account}), (Object)"\u5ba2\u670d\u8d26\u53f7\u540d\u4e3a\u7a7a");
        Preconditions.checkArgument((media != null ? 1 : 0) != 0, (Object)"\u5934\u50cf\u6587\u4ef6\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)media.getFilename().toLowerCase().endsWith("jpg"), (Object)"\u5934\u50cf\u56fe\u7247\u6587\u4ef6\u5fc5\u987b\u662fjpg\u683c\u5f0f");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        HashMap params = Maps.newHashMap();
        params.put("media", media);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = MessageFormat.format(this.wxCustomAccountUploadHeadImg, accessToken, account);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ErrorCode.class, new Object[0]);
        WeixinException.isSuccess((ErrorCode)response.getBody());
    }

    public List<CustomAccount> getAll(@NonNull String accessToken) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("get custom account list");
        String url = MessageFormat.format(this.wxCustomAccountGetKflist, accessToken);
        ResponseEntity response = this.restTemplate.getForEntity(url, CustomAccountList.class, new Object[0]);
        CustomAccountList result = (CustomAccountList)response.getBody();
        WeixinException.isSuccess(result);
        return result.getList();
    }

    public List<OnlineCustomAccount> getOnlineList(@NonNull String accessToken) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("get online custom account list");
        String url = MessageFormat.format(this.wxCustomAccountGetOnlineKflist, accessToken);
        ResponseEntity response = this.restTemplate.getForEntity(url, OnlineList.class, new Object[0]);
        OnlineList result = (OnlineList)response.getBody();
        WeixinException.isSuccess(result);
        return result.getList();
    }
}

