/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.analysis;

import cn.kinyun.scrm.weixin.sdk.entity.analysis.AnalysisReq;
import cn.kinyun.scrm.weixin.sdk.entity.analysis.article.ArticleSummary;
import cn.kinyun.scrm.weixin.sdk.entity.analysis.article.ArticleTotal;
import cn.kinyun.scrm.weixin.sdk.entity.analysis.article.UserRead;
import cn.kinyun.scrm.weixin.sdk.entity.analysis.article.UserReadHour;
import cn.kinyun.scrm.weixin.sdk.entity.analysis.article.UserShare;
import cn.kinyun.scrm.weixin.sdk.entity.analysis.article.UserShareHour;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import java.text.MessageFormat;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WxArticleAnalysisAPI {
    private static final Logger log = LoggerFactory.getLogger(WxArticleAnalysisAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.analysis.getarticlesummary}")
    private String wxAnalysisGetArticleSummary;
    @Value(value="${wx.analysis.getarticletotal}")
    private String wxAnalysisGetArticleTotal;
    @Value(value="${wx.analysis.getuserread}")
    private String wxAnalysisGetUserRead;
    @Value(value="${wx.analysis.getuserreadhour}")
    private String wxAnalysisGetUserReadHour;
    @Value(value="${wx.analysis.getusershare}")
    private String wxAnalysisGetUserShare;
    @Value(value="${wx.analysis.getusersharehour}")
    private String wxAnalysisGetUserShareHour;

    public ArticleSummary getArticleSummary(@NonNull String accessToken, @NonNull AnalysisReq params) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        log.info("get article summary with params={}", (Object)params);
        String url = MessageFormat.format(this.wxAnalysisGetArticleSummary, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ArticleSummary.class, new Object[0]);
        ArticleSummary result = (ArticleSummary)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public ArticleTotal getArticleTotal(@NonNull String accessToken, @NonNull AnalysisReq params) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        log.info("get article total with params={}", (Object)params);
        String url = MessageFormat.format(this.wxAnalysisGetArticleTotal, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ArticleTotal.class, new Object[0]);
        ArticleTotal result = (ArticleTotal)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public UserRead getUserRead(@NonNull String accessToken, @NonNull AnalysisReq params) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        log.info("get user read with params={}", (Object)params);
        String url = MessageFormat.format(this.wxAnalysisGetUserRead, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, UserRead.class, new Object[0]);
        UserRead result = (UserRead)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public UserReadHour getUserReadHour(@NonNull String accessToken, @NonNull AnalysisReq params) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        log.info("get user read hour with params={}", (Object)params);
        String url = MessageFormat.format(this.wxAnalysisGetUserReadHour, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, UserReadHour.class, new Object[0]);
        UserReadHour result = (UserReadHour)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public UserShare getUserShare(@NonNull String accessToken, @NonNull AnalysisReq params) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        log.info("get user share with params={}", (Object)params);
        String url = MessageFormat.format(this.wxAnalysisGetUserShare, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, UserShare.class, new Object[0]);
        UserShare result = (UserShare)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public UserShareHour getUserShareHour(@NonNull String accessToken, @NonNull AnalysisReq params) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        log.info("get user share hour with params={}", (Object)params);
        String url = MessageFormat.format(this.wxAnalysisGetUserShareHour, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, UserShareHour.class, new Object[0]);
        UserShareHour result = (UserShareHour)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }
}

