/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.message.mass.resp.MsgId;
import cn.kinyun.scrm.weixin.sdk.entity.template.AddTemplate;
import cn.kinyun.scrm.weixin.sdk.entity.template.IndustryInfo;
import cn.kinyun.scrm.weixin.sdk.entity.template.PrivateTemplate;
import cn.kinyun.scrm.weixin.sdk.entity.template.PrivateTemplateList;
import cn.kinyun.scrm.weixin.sdk.entity.template.SetIndustry;
import cn.kinyun.scrm.weixin.sdk.entity.template.TemplateMsg;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.sdk.utils.JsonUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WxTemplateMsgAPI {
    private static final Logger log = LoggerFactory.getLogger(WxTemplateMsgAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.template.industry.set}")
    private String wxTemplateIndustrySet;
    @Value(value="${wx.template.industry.get}")
    private String wxTemplateIndustryGet;
    @Value(value="${wx.template.add}")
    private String wxTemplateAdd;
    @Value(value="${wx.template.getAll}")
    private String wxTemplateGetAll;
    @Value(value="${wx.template.delete}")
    private String wxTemplateDelete;
    @Value(value="${wx.message.template.send}")
    private String wxMessageTemplateSend;

    public void setIndustry(@NonNull String accessToken, @NonNull SetIndustry params) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        log.info("set industry with params={}", (Object)params);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getIndustryId1()}), (Object)"\u4e3b\u8425\u884c\u4e1a\u7f16\u53f7\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getIndustryId2()}), (Object)"\u526f\u8425\u884c\u4e1a\u7f16\u53f7\u4e3a\u7a7a");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = MessageFormat.format(this.wxTemplateIndustrySet, accessToken);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ErrorCode.class, new Object[0]);
        WeixinException.isSuccess((ErrorCode)response.getBody());
    }

    public IndustryInfo getIndustry(@NonNull String accessToken) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("get industry");
        String url = MessageFormat.format(this.wxTemplateIndustryGet, accessToken);
        ResponseEntity response = this.restTemplate.getForEntity(url, IndustryInfo.class, new Object[0]);
        IndustryInfo result = (IndustryInfo)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public String addPrivateTemplate(@NonNull String accessToken, @NonNull AddTemplate addTemplate) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (addTemplate == null) {
            throw new NullPointerException("addTemplate is marked non-null but is null");
        }
        log.info("add template with shortId={}", (Object)addTemplate.getTemplateIdShort());
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{addTemplate.getTemplateIdShort()}), (Object)"\u6a21\u677f\u77edID\u4e3a\u7a7a");
        Preconditions.checkArgument((addTemplate.getKeywordNameList() != null && !addTemplate.getKeywordNameList().isEmpty() ? 1 : 0) != 0, (Object)"\u516c\u4f17\u53f7\u6a21\u677f\u6d88\u606f\u6240\u5c5e\u884c\u4e1a\u7f16\u53f7\u4e3a\u7a7a");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("template_id_short", addTemplate.getTemplateIdShort());
        params.put("keyword_name_list", addTemplate.getKeywordNameList());
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = MessageFormat.format(this.wxTemplateAdd, accessToken);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, PrivateTemplate.class, new Object[0]);
        PrivateTemplate result = (PrivateTemplate)response.getBody();
        WeixinException.isSuccess(result);
        return result.getTemplateId();
    }

    public List<PrivateTemplate> getAllPrivateTemplate(@NonNull String accessToken) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("get all private template");
        String url = MessageFormat.format(this.wxTemplateGetAll, accessToken);
        ResponseEntity response = this.restTemplate.getForEntity(url, PrivateTemplateList.class, new Object[0]);
        PrivateTemplateList result = (PrivateTemplateList)response.getBody();
        WeixinException.isSuccess(result);
        return result.getList();
    }

    public void deletePrivateTemplate(@NonNull String accessToken, @NonNull String templateId) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (templateId == null) {
            throw new NullPointerException("templateId is marked non-null but is null");
        }
        log.info("delete private template with templateId={}", (Object)templateId);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{templateId}), (Object)"\u6a21\u677fID\u4e3a\u7a7a");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("template_id", templateId);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = MessageFormat.format(this.wxTemplateDelete, accessToken);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ErrorCode.class, new Object[0]);
        WeixinException.isSuccess((ErrorCode)response.getBody());
    }

    public MsgId sendTemplateMsg(@NonNull String accessToken, @NonNull TemplateMsg params) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        log.info("send template msg with params={}", (Object)params);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getToUserName()}), (Object)"\u63a5\u53d7\u8005\u7684openid\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getTemplateId()}), (Object)"\u6d88\u606f\u6a21\u677fID\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getData() != null ? 1 : 0) != 0, (Object)"\u6a21\u677f\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((!params.getData().isEmpty() ? 1 : 0) != 0, (Object)"\u6a21\u677f\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getMiniProgram() == null || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getMiniProgram().getAppId()}) ? 1 : 0) != 0, (Object)"\u5c0f\u7a0b\u5e8fappid\u4e3a\u7a7a");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        byte[] data = JsonUtil.obj2Str(params).getBytes();
        HttpEntity request = new HttpEntity((Object)data, (MultiValueMap)headers);
        String url = MessageFormat.format(this.wxMessageTemplateSend, accessToken);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, MsgId.class, new Object[0]);
        MsgId msgId = (MsgId)response.getBody();
        WeixinException.isSuccess(msgId);
        return msgId;
    }
}

