/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.template;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import java.io.Serializable;
import java.util.List;

/**
 * 设置行业信息
 * 
 * @title AddTemplate
 * @desc 新增模板
 * @author yanmaoyuan
 * @date 2024年7月15日
 * @version 1.0
 */
@Data
public class AddTemplate implements Serializable {


    private static final long serialVersionUID = 7303259738264043345L;

    /**
     * 公众号模板消息所属主营行业编号
     */
    @JsonProperty("template_id_short")
    private String templateIdShort;

    /**
     * 公众号模板消息所属行业编号
     */
    @JsonProperty("keyword_name_list")
    private List<String> keywordNameList;

    public AddTemplate(String templateIdShort, List<String> keywordNameList) {
        this.templateIdShort = templateIdShort;
        this.keywordNameList = keywordNameList;
    }
}
