package cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req;

import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.dto.AuditItemListDto;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.dto.AuditPreviewInfoDto;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.dto.AuditUgcDeclareDto;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * @author Created by chenjiaqiang on 2022/01/19
 * 注意：只有上个版本被驳回，才能使用 feedback_info、feedback_stuff 这两个字段，否则忽略处理。
 * 当小程序第一次提交审核且类目包含社交-社区/论坛、社交-笔记、社交-问答其中之一时需填写 ugc_declare
 **/
@Data
public class SubmitAuditReq {

    /**
     * 审核项列表（选填，至多填写 5 项）
     */
    @JsonProperty("item_list")
    private List<AuditItemListDto> itemList;

    /**
     * 预览信息（小程序页面截图和操作录屏）
     */
    @JsonProperty("preview_info")
    private AuditPreviewInfoDto previewInfo;

    /**
     * 小程序版本说明和功能解释
     */
    @JsonProperty("version_desc")
    private String versionDesc;

    /**
     * 反馈内容，至多 200 字
     */
    @JsonProperty("feedback_info")
    private String feedbackInfo;

    /**
     * 用 | 分割的 media_id 列表，至多 5 张图片, 可以通过新增临时素材接口上传而得到
     */
    @JsonProperty("feedback_stuff")
    private String feedbackStuff;

    /**
     * 用户生成内容场景（UGC）信息安全声明
     */
    @JsonProperty("ugc_declare")
    private AuditUgcDeclareDto ugcDeclare;

    @JsonProperty("order_path")
    private String orderPath;

}
