package cn.kinyun.scrm.weixin.sdk.entity.miniprogram.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * @author zhangjing
 * @desc
 * @date 2022/1/17 6:00 下午
 */
@Data
public class TemplateItemDto {

    /**
     * 被添加为模板的时间
     */
    @JsonProperty("create_time")
    private Long createTime;

    /**
     * 模板版本号，开发者自定义字段
     */
    @JsonProperty("user_version")
    private String userVersion;

    /**
     * 模板描述，开发者自定义字段
     */
    @JsonProperty("user_desc")
    private String userDesc;

    /**
     * 模板 id
     */
    @JsonProperty("template_id")
    private String templateId;

    /**
     * 0对应普通模板，1对应标准模板
     */
    @JsonProperty("template_type")
    private Integer templateType;

    /**
     * 开发小程序的appid
     */
    @JsonProperty("source_miniprogram_appid")
    private String sourceMiniprogramAppid;

    /**
     * 开发小程序的名称
     */
    @JsonProperty("source_miniprogram")
    private String sourceMiniprogram;

    @JsonProperty("category_list")
    private List<TemplateCategoryDto> categoryList;

    /**
     * 标准模板的场景标签；普通模板不返回该值
     */
    @JsonProperty("audit_scene")
    private Integer auditScene;

    /**
     * 标准模板的审核状态；普通模板不返回该值
     */
    @JsonProperty("audit_status")
    private Integer auditStatus;

    /**
     * 标准模板的审核驳回的原因；普通模板不返回该值
     */
    private String reason;
}
