package cn.kinyun.scrm.weixin.sdk.entity.miniprogram.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * @author Created by chenjiaqiang on 2022/01/19
 * 审核项
 **/
@Data
public class AuditItemListDto {

    /**
     * 小程序的页面，可通过获取小程序的页面列表接口获得
     */
    private String address;

    /**
     * 小程序的标签，用空格分隔，标签至多 10 个，标签长度至多 20
     */
    private String tag;

    /**
     * 一级类目名称
     */
    @JsonProperty("first_class")
    private String firstClass;

    @JsonProperty("second_class")
    private String secondClass;

    @JsonProperty("third_class")
    private String thirdClass;

    @JsonProperty("first_id")
    private Long firstId;

    @JsonProperty("second_id")
    private Long secondId;

    @JsonProperty("third_id")
    private Long thirdId;

    /**
     * 小程序页面的标题,标题长度至多 32
     */
    private String title;

}
