/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.message;

import cn.kinyun.scrm.weixin.sdk.enums.WxMsgType;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import java.io.Serializable;

import lombok.Data;

/**
 * 消息的公共字段
 * 
 * <p>此类是所有用于接收、发送公众号消息的消息类的基类，其中存储了消息的公共字段。</p>
 * 
 * <p>在接收、发送微信公众号消息时，消息的原始格式为xml。代码中使用<code>@JacksonXmlProperty</code>注解来标注xml元素与类中属性的映射关系。</p>
 * 
 * @title BaseMsg
 * @desc 消息的公共字段
 * @author yanmaoyuan
 * @date 2019年4月24日
 * @version 1.0
 */
@Data
@JacksonXmlRootElement(localName = "xml")
public class BaseMsg implements Serializable {

    private static final long serialVersionUID = -2321137513257884125L;

    /**
     * 开发者微信号
     */
    @JacksonXmlProperty(localName = "ToUserName")
    protected String toUserName;

    /**
     * 发送方帐号（一个OpenID）
     */
    @JacksonXmlProperty(localName = "FromUserName")
    protected String fromUserName;

    /**
     * 消息创建时间（整型）
     */
    @JacksonXmlProperty(localName = "CreateTime")
    protected Long createTime;

    /**
     * 消息类型
     * 
     * @see WxMsgType
     */
    @JacksonXmlProperty(localName = "MsgType")
    protected String msgType;

}