/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.analysis.api;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * @title ApiSummaryDto
 * @author yanmaoyuan
 * @date 2019年9月25日
 * @version 1.0
 */
@Data
public class ApiSummaryDto implements Serializable {

    private static final long serialVersionUID = -1441332150616130272L;

    /**
     * 数据的日期，需在begin_date和end_date之间
     */
    @JsonAlias("ref_date")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date refDate;

    /**
     * 通过服务器配置地址获得消息后，被动回复用户消息的次数
     */
    @JsonAlias("callback_count")
    private int callbackCount;

    /**
     * 上述动作的失败次数
     */
    @JsonAlias("fail_count")
    private int failCount;

    /**
     * 总耗时，除以callback_count即为平均耗时
     */
    @JsonAlias("total_time_cost")
    private int totalTimeCost;

    /**
     * 最大耗时
     */
    @JsonAlias("max_time_cost")
    private int maxTimeCost;
}