/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.shop;

import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.ShopInfoResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.HashMap;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WxShopAPI {
    private static final Logger log = LoggerFactory.getLogger(WxShopAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.shop.base.info}")
    private String shopBaseInfoUrl;

    public ShopInfoResp getShopInfo(@NonNull String accessToken) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("getShopInfo");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopBaseInfoUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ShopInfoResp.class, new Object[0]);
        ShopInfoResp result = (ShopInfoResp)resp.getBody();
        log.info("getShopInfo result={}", (Object)result);
        WeixinException.isSuccess(result);
        return result;
    }
}

