/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.applet;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.FastCreateReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.SearchStatusReq;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.google.common.base.Preconditions;
import java.text.MessageFormat;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class AppletRegisterAPI {
    private static final Logger log = LoggerFactory.getLogger(AppletRegisterAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.applet.register.fast_register_create}")
    private String appletRegisterFastCreateListUrl;
    @Value(value="${wx.applet.register.fast_register_search}")
    private String appletRegisterFastSearchListUrl;

    public ErrorCode fastCreate(@NonNull String componentAccessToken, @NonNull FastCreateReq req) {
        if (componentAccessToken == null) {
            throw new NullPointerException("componentAccessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("fastCreate with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{componentAccessToken}), (Object)"componentAccessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.appletRegisterFastCreateListUrl, componentAccessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public ErrorCode searchStatus(@NonNull String componentAccessToken, @NonNull SearchStatusReq req) {
        if (componentAccessToken == null) {
            throw new NullPointerException("componentAccessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("searchStatus with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{componentAccessToken}), (Object)"componentAccessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.appletRegisterFastSearchListUrl, componentAccessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }
}

