/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.applet;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.ApplyPluginReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.PluginListReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.UnbindPluginReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.UpdatePluginReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.AppletPluginListResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.google.common.base.Preconditions;
import java.text.MessageFormat;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class AppletPluginAPI {
    private static final Logger log = LoggerFactory.getLogger(AppletPluginAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.applet.plugin.url}")
    private String appletPluginUrl;

    public ErrorCode applyPlugin(@NonNull String accessToken, @NonNull ApplyPluginReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("applyPlugin with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        req.validate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.appletPluginUrl, accessToken);
        ResponseEntity resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public AppletPluginListResp getPluginList(@NonNull String accessToken) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("getPluginList");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        PluginListReq req = new PluginListReq();
        req.setAction("list");
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.appletPluginUrl, accessToken);
        ResponseEntity resp = this.restTemplate.postForEntity(url, (Object)httpEntity, AppletPluginListResp.class, new Object[0]);
        AppletPluginListResp result = (AppletPluginListResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public ErrorCode unbindPlugin(@NonNull String accessToken, @NonNull UnbindPluginReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("unbindPlugin with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.appletPluginUrl, accessToken);
        ResponseEntity resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public ErrorCode updatePlugin(@NonNull String accessToken, @NonNull UpdatePluginReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("updatePlugin with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.appletPluginUrl, accessToken);
        ResponseEntity resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }
}

