/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.analysis;

import cn.kinyun.scrm.weixin.sdk.entity.analysis.AnalysisReq;
import cn.kinyun.scrm.weixin.sdk.entity.analysis.msg.UpstreamMsg;
import cn.kinyun.scrm.weixin.sdk.entity.analysis.msg.UpstreamMsgDist;
import cn.kinyun.scrm.weixin.sdk.entity.analysis.msg.UpstreamMsgHour;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import java.text.MessageFormat;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WxMsgAnalysisAPI {
    private static final Logger log = LoggerFactory.getLogger(WxMsgAnalysisAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.analysis.getupstreammsg}")
    private String wxAnalysisGetUpstreamMsg;
    @Value(value="${wx.analysis.getupstreammsghour}")
    private String wxAnalysisGetUpstreamMsgHour;
    @Value(value="${wx.analysis.getupstreammsgweek}")
    private String wxAnalysisGetUpstreamMsgWeek;
    @Value(value="${wx.analysis.getupstreammsgmonth}")
    private String wxAnalysisGetUpstreamMsgMonth;
    @Value(value="${wx.analysis.getupstreammsgdist}")
    private String wxAnalysisGetUpstreamMsgDist;
    @Value(value="${wx.analysis.getupstreammsgdistweek}")
    private String wxAnalysisGetUpstreamMsgDistWeek;
    @Value(value="${wx.analysis.getupstreammsgdistmonth}")
    private String wxAnalysisGetUpstreamMsgDistMonth;

    public UpstreamMsg getUpstreamMsg(@NonNull String accessToken, @NonNull AnalysisReq params) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        log.info("get upstream msg with params={}", (Object)params);
        String url = MessageFormat.format(this.wxAnalysisGetUpstreamMsg, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, UpstreamMsg.class, new Object[0]);
        UpstreamMsg result = (UpstreamMsg)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public UpstreamMsgHour getUpstreamMsgHour(@NonNull String accessToken, @NonNull AnalysisReq params) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        log.info("get upstream msg hour with params={}", (Object)params);
        String url = MessageFormat.format(this.wxAnalysisGetUpstreamMsgHour, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, UpstreamMsgHour.class, new Object[0]);
        UpstreamMsgHour result = (UpstreamMsgHour)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public UpstreamMsg getUpstreamMsgWeek(@NonNull String accessToken, @NonNull AnalysisReq params) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        log.info("get upstream msg week with params={}", (Object)params);
        String url = MessageFormat.format(this.wxAnalysisGetUpstreamMsgWeek, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, UpstreamMsg.class, new Object[0]);
        UpstreamMsg result = (UpstreamMsg)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public UpstreamMsg getUpstreamMsgMonth(@NonNull String accessToken, @NonNull AnalysisReq params) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        log.info("get upstream msg month with params={}", (Object)params);
        String url = MessageFormat.format(this.wxAnalysisGetUpstreamMsgMonth, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, UpstreamMsg.class, new Object[0]);
        UpstreamMsg result = (UpstreamMsg)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public UpstreamMsgDist getUpstreamMsgDist(@NonNull String accessToken, @NonNull AnalysisReq params) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        log.info("get upstream msg dist with params={}", (Object)params);
        String url = MessageFormat.format(this.wxAnalysisGetUpstreamMsgDist, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, UpstreamMsgDist.class, new Object[0]);
        UpstreamMsgDist result = (UpstreamMsgDist)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public UpstreamMsgDist getUpstreamMsgDistWeek(@NonNull String accessToken, @NonNull AnalysisReq params) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        log.info("get upstream msg dist week with params={}", (Object)params);
        String url = MessageFormat.format(this.wxAnalysisGetUpstreamMsgDistWeek, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, UpstreamMsgDist.class, new Object[0]);
        UpstreamMsgDist result = (UpstreamMsgDist)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public UpstreamMsgDist getUpstreamMsgDistMonth(@NonNull String accessToken, @NonNull AnalysisReq params) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        log.info("get upstream msg dist month with params={}", (Object)params);
        String url = MessageFormat.format(this.wxAnalysisGetUpstreamMsgDistMonth, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, UpstreamMsgDist.class, new Object[0]);
        UpstreamMsgDist result = (UpstreamMsgDist)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }
}

