/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.account;

import cn.kinyun.scrm.weixin.sdk.entity.account.CreateQrcodeResult;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.HashMap;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WxQrcodeAPI {
    private static final Logger log = LoggerFactory.getLogger(WxQrcodeAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.qrcode.create}")
    private String wxQrcodeCreate;
    @Value(value="${wx.qrcode.get}")
    private String wxQrcodeGet;

    public CreateQrcodeResult createQrcode(@NonNull String accessToken, @NonNull Integer sceneId, Integer expireSeconds) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (sceneId == null) {
            throw new NullPointerException("sceneId is marked non-null but is null");
        }
        log.info("create temp qrcode with sceneId={}, expireSeconds={}", (Object)sceneId, (Object)expireSeconds);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        if (expireSeconds != null && expireSeconds > 0) {
            params.put("expire_seconds", expireSeconds);
        }
        params.put("action_name", "QR_SCENE");
        HashMap scene = Maps.newHashMap();
        scene.put("scene_id", sceneId);
        HashMap actionInfo = Maps.newHashMap();
        actionInfo.put("scene", scene);
        params.put("action_info", actionInfo);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = MessageFormat.format(this.wxQrcodeCreate, accessToken);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, CreateQrcodeResult.class, new Object[0]);
        CreateQrcodeResult result = (CreateQrcodeResult)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public CreateQrcodeResult createQrcode(@NonNull String accessToken, @NonNull String sceneStr, Integer expireSeconds) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (sceneStr == null) {
            throw new NullPointerException("sceneStr is marked non-null but is null");
        }
        log.info("create temp qrcode with sceneStr={}, expireSeconds={}", (Object)sceneStr, (Object)expireSeconds);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        if (expireSeconds != null && expireSeconds > 0) {
            params.put("expire_seconds", expireSeconds);
        }
        params.put("action_name", "QR_STR_SCENE");
        HashMap scene = Maps.newHashMap();
        scene.put("scene_str", sceneStr);
        HashMap actionInfo = Maps.newHashMap();
        actionInfo.put("scene", scene);
        params.put("action_info", actionInfo);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = MessageFormat.format(this.wxQrcodeCreate, accessToken);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, CreateQrcodeResult.class, new Object[0]);
        CreateQrcodeResult result = (CreateQrcodeResult)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public CreateQrcodeResult createQrcode(@NonNull String accessToken, @NonNull Integer sceneId) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (sceneId == null) {
            throw new NullPointerException("sceneId is marked non-null but is null");
        }
        log.info("create qrcode with sceneId={}", (Object)sceneId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("action_name", "QR_LIMIT_SCENE");
        HashMap scene = Maps.newHashMap();
        scene.put("scene_id", sceneId);
        HashMap actionInfo = Maps.newHashMap();
        actionInfo.put("scene", scene);
        params.put("action_info", actionInfo);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = MessageFormat.format(this.wxQrcodeCreate, accessToken);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, CreateQrcodeResult.class, new Object[0]);
        CreateQrcodeResult result = (CreateQrcodeResult)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public CreateQrcodeResult createQrcode(@NonNull String accessToken, @NonNull String sceneStr) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (sceneStr == null) {
            throw new NullPointerException("sceneStr is marked non-null but is null");
        }
        log.info("create qrcode with sceneStr={}", (Object)sceneStr);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("action_name", "QR_LIMIT_STR_SCENE");
        HashMap scene = Maps.newHashMap();
        scene.put("scene_str", sceneStr);
        HashMap actionInfo = Maps.newHashMap();
        actionInfo.put("scene", scene);
        params.put("action_info", actionInfo);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        String url = MessageFormat.format(this.wxQrcodeCreate, accessToken);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, CreateQrcodeResult.class, new Object[0]);
        CreateQrcodeResult result = (CreateQrcodeResult)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public String getQrcodeUrl(@NonNull String ticket) {
        if (ticket == null) {
            throw new NullPointerException("ticket is marked non-null but is null");
        }
        try {
            ticket = URLEncoder.encode(ticket, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return MessageFormat.format(this.wxQrcodeGet, ticket);
    }
}

