package cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * @author zhangjing
 * @desc
 * @date 2022/1/18 9:59 上午
 */
@Data
public class FastCreateReq {

    /**
     * 必填, 企业名
     */
    private String name;

    /**
     * 必填, 企业代码
     */
    private String code;

    /**
     * 必填, 企业代码类型（1：统一社会信用代码， 2：组织机构代码，3：营业执照注册号）
     */
    @JsonProperty("code_type")
    private Integer codeType;

    /**
     * 法人微信
     */
    @JsonProperty("legal_persona_wechat")
    private String legalPersonaWechat;

    /**
     * 法人姓名
     */
    @JsonProperty("legal_persona_name")
    private String legalPersonaName;

    /**
     * 第三方联系电话
     */
    @JsonProperty("component_phone")
    private String componentPhone;

}
