/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.message.event.menu;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.BaseEvent;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 自定义菜单事件
 * 
 * <p>用户点击自定义菜单后，微信会把点击事件推送给开发者，请注意，点击菜单弹出子菜单，不会产生上报。</p>
 * 
 * <p>点击菜单跳转链接时的事件推送</p>
 * 
 * @title ViewEvent
 * @desc 自定义菜单事件
 * @author yanmaoyuan
 * @date 2019年4月24日
 * @version 1.0
 */
@Data
@ToString(callSuper=true)
@EqualsAndHashCode(callSuper=true)
public class ViewEvent extends BaseEvent {

    private static final long serialVersionUID = 3736732747533483930L;

    /**
     * 事件KEY值，设置的跳转URL
     */
    @JacksonXmlProperty(localName = "EventKey")
    private String eventKey;

    /**
     * 指菜单ID，如果是个性化菜单，则可以通过这个字段，知道是哪个规则的菜单被点击了。
     */
    @JacksonXmlProperty(localName = "MenuId")
    private String menuId;
}