package cn.kinyun.scrm.weixin.sdk.entity.material.resp;

import com.fasterxml.jackson.annotation.JsonProperty;
import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.material.dto.MaterialDto;

import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @ClassName MaterialResp
 * @Description
 * @Author zhangjing
 * @DATE 2019/4/29 15:48
 * @Version 1.0
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ToString(callSuper=true)
public class MaterialResp extends ErrorCode {

    private static final long serialVersionUID = -8203145497675357521L;
    /**
     * 该类型的素材的总数
     */
    @JsonProperty("total_count")
    Integer totalCount;

    /**
     * 本次调用获取的素材的数量
     */
    @JsonProperty("item_count")
    Integer itemCount;

    /**
     * 素材内容
     */
    @JsonProperty("item")
    List<MaterialDto> item;
}
