package cn.kinyun.scrm.weixin.sdk.entity.component;

import com.fasterxml.jackson.annotation.JsonAlias;
import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author : shanyu
 * @version V1.0
 * @Project: weixin-platform
 * @Package com.kuaike.weixin.component.api.entity;
 * @Description: 第三方平台access_token响应信息
 * @date Date : 2019年04月22日 14:36
 */
@Data
@EqualsAndHashCode(callSuper= true)
public class AccessToken extends ErrorCode {

    private static final long serialVersionUID = -8041806141529767724L;
    /**
     * 第三方平台access_token
     */
    @JsonAlias("component_access_token")
    private String componentAccessToken;

    /**
     * 有效期
     */
    @JsonAlias("expires_in")
    private long expires;
}
