/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.shop;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.SpuResultDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SpuAddReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SpuGetReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SpuListReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SpuProductIdReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SpuSearchReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.SpuUpdateReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.SpuAddResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.SpuGetResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.SpuListResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.SpuUpdateResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.sdk.utils.JsonUtil;
import com.google.common.base.Preconditions;
import java.text.MessageFormat;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WxShopSpuAPI {
    private static final Logger log = LoggerFactory.getLogger(WxShopSpuAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.shop.spu.add}")
    private String shopSpuAddUrl;
    @Value(value="${wx.shop.spu.del}")
    private String shopSpuDelUrl;
    @Value(value="${wx.shop.spu.get}")
    private String shopSpuGetUrl;
    @Value(value="${wx.shop.spu.get_list}")
    private String shopSpuGetListUrl;
    @Value(value="${wx.shop.spu.search}")
    private String shopSpuSearchUrl;
    @Value(value="${wx.shop.spu.update}")
    private String shopSpuUpdateUrl;
    @Value(value="${wx.shop.spu.listing}")
    private String shopSpuListingUrl;
    @Value(value="${wx.shop.spu.delisting}")
    private String shopSpuDeListingUrl;

    public SpuAddResp spuAdd(@NonNull String accessToken, @NonNull SpuAddReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("spuAdd with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        byte[] data = JsonUtil.obj2Str(req).getBytes();
        HttpEntity httpEntity = new HttpEntity((Object)data, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopSpuAddUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, SpuAddResp.class, new Object[0]);
        SpuAddResp result = (SpuAddResp)resp.getBody();
        log.info("spuAdd with result={}", (Object)result);
        WeixinException.isSuccess(result);
        return result;
    }

    public SpuGetResp spuGet(@NonNull String accessToken, @NonNull SpuGetReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("spuGet with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        req.validate();
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopSpuGetUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, SpuGetResp.class, new Object[0]);
        SpuGetResp result = (SpuGetResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public SpuListResp spuList(@NonNull String accessToken, @NonNull SpuListReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("spuList with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        req.validate();
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopSpuGetListUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, SpuListResp.class, new Object[0]);
        SpuListResp result = (SpuListResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public ErrorCode spuDel(@NonNull String accessToken, @NonNull SpuProductIdReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("spuDel with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        req.validate();
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopSpuDelUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public SpuResultDto spuSearch(@NonNull String accessToken, @NonNull SpuSearchReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("spuSearch with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopSpuSearchUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, SpuResultDto.class, new Object[0]);
        SpuResultDto result = (SpuResultDto)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public SpuUpdateResp spuUpdate(@NonNull String accessToken, @NonNull SpuUpdateReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("spuUpdate with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopSpuUpdateUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, SpuUpdateResp.class, new Object[0]);
        SpuUpdateResp result = (SpuUpdateResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public ErrorCode spuListing(@NonNull String accessToken, @NonNull SpuProductIdReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("spuListing with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        req.validate();
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopSpuListingUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public ErrorCode spuDelisting(@NonNull String accessToken, @NonNull SpuProductIdReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("spuDelisting with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        req.validate();
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopSpuDeListingUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }
}

