/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.shop;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.OrderChangeNoteReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.OrderDetailReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.OrderGetListReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.OrderPriceChangeReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.OrderSearchReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.OrderDetailResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.OrderGetListResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.google.common.base.Preconditions;
import java.text.MessageFormat;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WxShopOrderAPI {
    private static final Logger log = LoggerFactory.getLogger(WxShopOrderAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.shop.order.get_list}")
    private String shopOrderGetListUrl;
    @Value(value="${wx.shop.order.get}")
    private String shopOrderGetUrl;
    @Value(value="${wx.shop.order.search}")
    private String shopOrderSearchUrl;
    @Value(value="${wx.shop.order.change_order_price}")
    private String shopOrderChangeOrderPriceUrl;
    @Value(value="${wx.shop.order.change_merchant_notes}")
    private String shopOrderChangeMerchantNotesUrl;

    public OrderGetListResp orderGetList(@NonNull String accessToken, @NonNull OrderGetListReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("orderGetList with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopOrderGetListUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, OrderGetListResp.class, new Object[0]);
        OrderGetListResp result = (OrderGetListResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public OrderDetailResp orderGetDetail(@NonNull String accessToken, @NonNull OrderDetailReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("orderGetDetail with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopOrderGetUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, OrderDetailResp.class, new Object[0]);
        OrderDetailResp result = (OrderDetailResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public OrderGetListResp orderSearch(@NonNull String accessToken, @NonNull OrderSearchReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("orderSearch with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopOrderSearchUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, OrderGetListResp.class, new Object[0]);
        OrderGetListResp result = (OrderGetListResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public ErrorCode modOrderPrice(@NonNull String accessToken, @NonNull OrderPriceChangeReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("modOrderPrice with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopOrderChangeOrderPriceUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public ErrorCode modOrderNote(@NonNull String accessToken, @NonNull OrderChangeNoteReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("modOrderNote with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopOrderChangeMerchantNotesUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }
}

