/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.shop;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.AfterSaleAcceptApplyReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.AfterSaleBatchGetReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.AfterSaleGetReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.AfterSaleRejectRefundReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.AfterSaleUploadRefundCertificateReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.AfterSaleBatchGetResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.AfterSaleGetResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.google.common.base.Preconditions;
import java.text.MessageFormat;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WxShopAfterSaleAPI {
    private static final Logger log = LoggerFactory.getLogger(WxShopAfterSaleAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.shop.after_sale.get_after_sale_order}")
    private String shopGetAfterSaleOrderUrl;
    @Value(value="${wx.shop.after_sale.batch_get_after_sale_order}")
    private String shopBatchGetAfterSaleOrderUrl;
    @Value(value="${wx.shop.after_sale.accept_apply}")
    private String shopAfterSaleAcceptApplyUrl;
    @Value(value="${wx.shop.after_sale.reject_refund}")
    private String shopAfterSaleRejectRefundUrl;
    @Value(value="${wx.shop.after_sale.upload_refund_certificate}")
    private String shopAfterSaleUploadRefundCertificateUrl;

    public AfterSaleGetResp getAfterSaleOrder(@NonNull String accessToken, @NonNull AfterSaleGetReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("getAfterSaleOrder with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopGetAfterSaleOrderUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, AfterSaleGetResp.class, new Object[0]);
        AfterSaleGetResp result = (AfterSaleGetResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public AfterSaleBatchGetResp batchGetAfterSaleOrder(@NonNull String accessToken, @NonNull AfterSaleBatchGetReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("batchGetAfterSaleOrder with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopBatchGetAfterSaleOrderUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, AfterSaleBatchGetResp.class, new Object[0]);
        AfterSaleBatchGetResp result = (AfterSaleBatchGetResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public ErrorCode acceptApply(@NonNull String accessToken, @NonNull AfterSaleAcceptApplyReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("acceptApply with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopAfterSaleAcceptApplyUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public ErrorCode rejectRefund(@NonNull String accessToken, @NonNull AfterSaleRejectRefundReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("rejectRefund with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopAfterSaleRejectRefundUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public ErrorCode uploadRefundCertificate(@NonNull String accessToken, @NonNull AfterSaleUploadRefundCertificateReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("uploadRefundCertificate with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.shopAfterSaleUploadRefundCertificateUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }
}

