/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.menu;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.menu.req.CreateCustomerMenuReq;
import cn.kinyun.scrm.weixin.sdk.entity.menu.req.CustomizedMenuTestReq;
import cn.kinyun.scrm.weixin.sdk.entity.menu.req.DeleteCustomerMenuReq;
import cn.kinyun.scrm.weixin.sdk.entity.menu.req.MenuCreateEntity;
import cn.kinyun.scrm.weixin.sdk.entity.menu.resp.AllMenuResp;
import cn.kinyun.scrm.weixin.sdk.entity.menu.resp.CreateCustomizedResp;
import cn.kinyun.scrm.weixin.sdk.entity.menu.resp.CustomizedMenuConfResp;
import cn.kinyun.scrm.weixin.sdk.entity.menu.resp.CustomizedMenuTestResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.sdk.utils.JsonUtil;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class MenuAPI {
    private static final Logger log = LoggerFactory.getLogger(MenuAPI.class);
    @Autowired
    RestTemplate restTemplate;
    @Value(value="${wx.menu.create}")
    String createMenuUrl;
    @Value(value="${wx.menu.get}")
    String getAllMenuUrl;
    @Value(value="${wx.menu.delAll}")
    String delAllMenuUrl;
    @Value(value="${wx.menu.addCustomMenu}")
    String createCustomizedMenuUrl;
    @Value(value="${wx.menu.delCustomMenu}")
    String delCustomizedMenuUrl;
    @Value(value="${wx.menu.testMatchResult}")
    String testMatchResultUrl;
    @Value(value="${wx.menu.getCurrentCustomizedMenuInfo}")
    String currentCustomizedMenuInfoUrl;

    public ErrorCode createMenu(@NonNull String accessToken, @NonNull MenuCreateEntity entity) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        log.info("create menu with params={}", (Object)entity);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        byte[] data = JsonUtil.obj2Str(entity).getBytes();
        HttpEntity request = new HttpEntity((Object)data, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.createMenuUrl, (Object)request, ErrorCode.class, new Object[]{accessToken});
        WeixinException.isSuccess((ErrorCode)response.getBody());
        return (ErrorCode)response.getBody();
    }

    public AllMenuResp getAllMenu(@NonNull String accessToken) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("get all menu.");
        ResponseEntity response = this.restTemplate.getForEntity(this.getAllMenuUrl, AllMenuResp.class, new Object[]{accessToken});
        WeixinException.isSuccess((ErrorCode)response.getBody());
        return (AllMenuResp)response.getBody();
    }

    public ErrorCode deleteAllMenu(@NonNull String accessToken) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("delete all menu.");
        ResponseEntity response = this.restTemplate.getForEntity(this.delAllMenuUrl, ErrorCode.class, new Object[]{accessToken});
        WeixinException.isSuccess((ErrorCode)response.getBody());
        return (ErrorCode)response.getBody();
    }

    public CreateCustomizedResp createCustomizedMenu(@NonNull String accessToken, @NonNull CreateCustomerMenuReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("crete customize menu with params={}", (Object)req);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        byte[] data = JsonUtil.obj2Str(req).getBytes();
        HttpEntity request = new HttpEntity((Object)data, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.createCustomizedMenuUrl, (Object)request, CreateCustomizedResp.class, new Object[]{accessToken});
        WeixinException.isSuccess((ErrorCode)response.getBody());
        return (CreateCustomizedResp)response.getBody();
    }

    public ErrorCode delCustomizedMenu(@NonNull String accessToken, @NonNull DeleteCustomerMenuReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("delete customeized menu with params={}", (Object)req);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(this.delCustomizedMenuUrl, (Object)request, ErrorCode.class, new Object[]{accessToken});
        WeixinException.isSuccess((ErrorCode)responseEntity.getBody());
        return (ErrorCode)responseEntity.getBody();
    }

    public CustomizedMenuTestResp testMatchResult(@NonNull String accessToken, @NonNull CustomizedMenuTestReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("test match result with params={}", (Object)req);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(this.testMatchResultUrl, (Object)request, CustomizedMenuTestResp.class, new Object[]{accessToken});
        WeixinException.isSuccess((ErrorCode)responseEntity.getBody());
        return (CustomizedMenuTestResp)responseEntity.getBody();
    }

    public CustomizedMenuConfResp queryCustomizedMenuConf(@NonNull String accessToken) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("query customized menu conf.");
        ResponseEntity responseEntity = this.restTemplate.getForEntity(this.currentCustomizedMenuInfoUrl, CustomizedMenuConfResp.class, new Object[]{accessToken});
        WeixinException.isSuccess((ErrorCode)responseEntity.getBody());
        return (CustomizedMenuConfResp)responseEntity.getBody();
    }
}

