/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.material;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.HttpResponse;
import cn.kinyun.scrm.weixin.sdk.entity.material.dto.NewsContent;
import cn.kinyun.scrm.weixin.sdk.entity.material.dto.VideoMaterialDto;
import cn.kinyun.scrm.weixin.sdk.entity.material.req.AddNewsReq;
import cn.kinyun.scrm.weixin.sdk.entity.material.req.AddVideoReq;
import cn.kinyun.scrm.weixin.sdk.entity.material.req.ModifyNewsReq;
import cn.kinyun.scrm.weixin.sdk.entity.material.resp.AddMaterialResp;
import cn.kinyun.scrm.weixin.sdk.entity.material.resp.AddNewsResp;
import cn.kinyun.scrm.weixin.sdk.entity.material.resp.GetMaterialCountResp;
import cn.kinyun.scrm.weixin.sdk.entity.material.resp.GetMaterialResp;
import cn.kinyun.scrm.weixin.sdk.entity.material.resp.MaterialResp;
import cn.kinyun.scrm.weixin.sdk.entity.media.Attachment;
import cn.kinyun.scrm.weixin.sdk.enums.WxMediaType;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.sdk.utils.HttpClient;
import cn.kinyun.scrm.weixin.sdk.utils.HttpsClient;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.HashMap;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class MaterialApi {
    private static final Logger log = LoggerFactory.getLogger(MaterialApi.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx,material.news.add}")
    private String addNewsUrl;
    @Value(value="${wx.material.add}")
    private String addUrl;
    @Value(value="${wx.material.get}")
    private String getMaterialUrl;
    @Value(value="${wx.material.del}")
    private String delMaterialUrl;
    @Value(value="${wx.material.update}")
    private String updateMaterialUrl;
    @Value(value="${wx.material.count}")
    private String countUrl;
    @Value(value="${wx.material.list}")
    private String listUrl;

    public AddNewsResp addNews(@NonNull String accessToken, @NonNull AddNewsReq req) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity resp = this.restTemplate.postForEntity(this.addNewsUrl, (Object)request, AddNewsResp.class, new Object[]{accessToken});
        AddNewsResp result = (AddNewsResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public AddMaterialResp addVideo(@NonNull String accessToken, @NonNull File file, @NonNull AddVideoReq req) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        FileSystemResource resource = new FileSystemResource(file);
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"media", (Object)resource);
        param.add((Object)"filename", (Object)file.getName());
        param.add((Object)"description", (Object)req);
        HttpEntity httpEntity = new HttpEntity((Object)param);
        ResponseEntity resp = this.restTemplate.exchange(this.addUrl, HttpMethod.POST, httpEntity, AddMaterialResp.class, new Object[]{accessToken, WxMediaType.Video.getValue()});
        AddMaterialResp result = (AddMaterialResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public AddMaterialResp addMaterial(@NonNull String accessToken, @NonNull WxMediaType type, @NonNull File file) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        FileSystemResource resource = new FileSystemResource(file);
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"media", (Object)resource);
        param.add((Object)"filename", (Object)file.getName());
        HttpEntity httpEntity = new HttpEntity((Object)param);
        ResponseEntity resp = this.restTemplate.exchange(this.addUrl, HttpMethod.POST, httpEntity, AddMaterialResp.class, new Object[]{accessToken, type.getValue()});
        AddMaterialResp result = (AddMaterialResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public GetMaterialResp getMaterial(@NonNull String accessToken, @NonNull String mediaId) throws GeneralSecurityException, IOException, WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (mediaId == null) {
            throw new NullPointerException("mediaId is marked non-null but is null");
        }
        log.info("get material with media_id={}", (Object)mediaId);
        String url = MessageFormat.format(this.getMaterialUrl, accessToken);
        HashMap map = Maps.newHashMap();
        map.put("media_id", mediaId);
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString((Object)map);
        HttpsClient client = new HttpsClient();
        HttpResponse response = client.requestHttps(url, json);
        if (response == null) {
            WeixinException.isSuccess(-1);
            return null;
        }
        GetMaterialResp resp = new GetMaterialResp();
        if (response.getContentType() != null && (response.getContentType().contains("text/plain") || response.getContentType().contains("application/json"))) {
            String textString = IOUtils.toString((InputStream)response.getInputStream(), (String)"UTF-8");
            try {
                JSONObject result = JSONObject.parseObject((String)textString);
                if (result.containsKey((Object)"errcode") && result.getIntValue("errcode") != 0) {
                    resp.setErrMsg(result.getString("errmsg"));
                    resp.setErrCode(result.getInteger("errcode"));
                }
                if (result.containsKey((Object)"news_item")) {
                    resp.setType(1);
                    NewsContent content = (NewsContent)JSONObject.parseObject((String)textString, NewsContent.class);
                    resp.setNews(content);
                } else if (result.containsKey((Object)"down_url")) {
                    resp.setType(2);
                    VideoMaterialDto video = (VideoMaterialDto)JSONObject.parseObject((String)textString, VideoMaterialDto.class);
                    HttpClient httpClient = new HttpClient();
                    Attachment attachment = httpClient.download(video.getDownUrl());
                    video.setAttachment(attachment);
                    resp.setVideo(video);
                }
            }
            catch (JSONException e) {
                log.error("\u89e3\u6790\u5fae\u4fe1\u6c38\u4e45\u7d20\u6750\u8fd4\u56de\u7684json\u5931\u8d25", (Throwable)e);
                resp.setErrCode(-1);
                resp.setErrMsg("\u89e3\u6790json\u5931\u8d25:" + textString);
            }
        } else {
            resp.setType(3);
            String ds = response.getContentDisposition();
            String fileName = "";
            if (ds.contains("attachment;")) {
                fileName = ds.substring(ds.indexOf("filename=") + 10, ds.length());
            } else if (ds.contains("form-data;")) {
                fileName = ds.substring(ds.indexOf("filename=\"") + 10, ds.length() - 1);
            }
            Attachment attachment = new Attachment();
            attachment.setContentLength(response.getContentLength());
            attachment.setContentType(response.getContentType());
            attachment.setFileName(fileName);
            attachment.setInputStream(response.getInputStream());
            resp.setAttachment(attachment);
        }
        WeixinException.isSuccess(resp);
        return resp;
    }

    public void delMaterial(@NonNull String accessToken, @NonNull String mediaId) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (mediaId == null) {
            throw new NullPointerException("mediaId is marked non-null but is null");
        }
        HashMap map = Maps.newHashMap();
        map.put("media_id", mediaId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(this.delMaterialUrl, (Object)request, ErrorCode.class, new Object[]{accessToken});
        ErrorCode result = (ErrorCode)responseEntity.getBody();
        WeixinException.isSuccess(result);
    }

    public void modifyNews(@NonNull String accessToken, @NonNull ModifyNewsReq req) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(this.updateMaterialUrl, (Object)request, ErrorCode.class, new Object[]{accessToken});
        ErrorCode result = (ErrorCode)responseEntity.getBody();
        WeixinException.isSuccess(result);
    }

    public GetMaterialCountResp getMaterialCount(@NonNull String accessToken) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        ResponseEntity responseEntity = this.restTemplate.getForEntity(this.countUrl, GetMaterialCountResp.class, new Object[]{accessToken});
        GetMaterialCountResp result = (GetMaterialCountResp)responseEntity.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public MaterialResp materialList(@NonNull String accessToken, @NonNull WxMediaType type, @NonNull Integer offset, @NonNull Integer count) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (offset == null) {
            throw new NullPointerException("offset is marked non-null but is null");
        }
        if (count == null) {
            throw new NullPointerException("count is marked non-null but is null");
        }
        HashMap map = Maps.newHashMap();
        map.put("type", type.getValue());
        map.put("offset", offset >= 0 ? offset : 0);
        map.put("count", count >= 0 ? count : 20);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(this.listUrl, (Object)request, MaterialResp.class, new Object[]{accessToken});
        MaterialResp result = (MaterialResp)responseEntity.getBody();
        WeixinException.isSuccess(result);
        return result;
    }
}

