/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.component;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.component.AccessToken;
import cn.kinyun.scrm.weixin.sdk.entity.component.AuthInfoResp;
import cn.kinyun.scrm.weixin.sdk.entity.component.AuthorizerInfoResp;
import cn.kinyun.scrm.weixin.sdk.entity.component.AuthorizerOption;
import cn.kinyun.scrm.weixin.sdk.entity.component.AuthorizerToken;
import cn.kinyun.scrm.weixin.sdk.entity.component.PreAuthCode;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class ComponentAuthAPI {
    private static final Logger log = LoggerFactory.getLogger(ComponentAuthAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.component.access.token}")
    private String wxComponentAccessToken;
    @Value(value="${wx.component.preAuthCode}")
    private String wxComponentPreAuthCode;
    @Value(value="${wx.component.loginpage}")
    private String wxComponentLoginPage;
    @Value(value="${wx.component.bindcomponent}")
    private String wxComponentBindComponent;
    @Value(value="${wx.component.apiQueryAuth}")
    private String wxComponentApiQueryAuth;
    @Value(value="${wx.component.apiGetAuthorizerInfo}")
    private String wxComponentApiGetAuthorizerInfo;
    @Value(value="${wx.component.apiAuthorizerToken}")
    private String wxComponentApiAuthorizerToken;
    @Value(value="${wx.component.apiGetAuthorizerOption}")
    private String wxComponentApiGetAuthorizerOption;
    @Value(value="${wx.component.apiSetAuthorizerOption}")
    private String wxComponentApiSetAuthorizerOption;

    public String callBackAuthCode(@NonNull HttpServletRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        return request.getParameter("auth_code");
    }

    public AccessToken componentAccessToken(@NonNull String appId, @NonNull String appSecret, @NonNull String verifyTicket) throws WeixinException {
        if (appId == null) {
            throw new NullPointerException("appId is marked non-null but is null");
        }
        if (appSecret == null) {
            throw new NullPointerException("appSecret is marked non-null but is null");
        }
        if (verifyTicket == null) {
            throw new NullPointerException("verifyTicket is marked non-null but is null");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("component_appid", appId);
        params.put("component_appsecret", appSecret);
        params.put("component_verify_ticket", verifyTicket);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.wxComponentAccessToken, (Object)request, AccessToken.class, new Object[0]);
        AccessToken result = (AccessToken)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public PreAuthCode preAuthCode(@NonNull String accessToken, @NonNull String componetAppId) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (componetAppId == null) {
            throw new NullPointerException("componetAppId is marked non-null but is null");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("component_appid", componetAppId);
        String url = MessageFormat.format(this.wxComponentPreAuthCode, accessToken);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, PreAuthCode.class, new Object[0]);
        PreAuthCode result = (PreAuthCode)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public String loginPage(@NonNull String componentAppId, @NonNull String preAuthCode, @NonNull String redirectUri, int authType) {
        if (componentAppId == null) {
            throw new NullPointerException("componentAppId is marked non-null but is null");
        }
        if (preAuthCode == null) {
            throw new NullPointerException("preAuthCode is marked non-null but is null");
        }
        if (redirectUri == null) {
            throw new NullPointerException("redirectUri is marked non-null but is null");
        }
        return MessageFormat.format(this.wxComponentLoginPage, componentAppId, preAuthCode, redirectUri, authType);
    }

    public String bindcomponent(@NonNull String appId, @NonNull String preAuthCode, @NonNull String redirectUri, int authType) {
        if (appId == null) {
            throw new NullPointerException("appId is marked non-null but is null");
        }
        if (preAuthCode == null) {
            throw new NullPointerException("preAuthCode is marked non-null but is null");
        }
        if (redirectUri == null) {
            throw new NullPointerException("redirectUri is marked non-null but is null");
        }
        return MessageFormat.format(this.wxComponentBindComponent, appId, preAuthCode, redirectUri, authType);
    }

    public AuthInfoResp apiQueryAuth(@NonNull String accessToken, @NonNull String componetAppId, @NonNull String authorizationCode) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (componetAppId == null) {
            throw new NullPointerException("componetAppId is marked non-null but is null");
        }
        if (authorizationCode == null) {
            throw new NullPointerException("authorizationCode is marked non-null but is null");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("component_appid", componetAppId);
        params.put("authorization_code", authorizationCode);
        String url = MessageFormat.format(this.wxComponentApiQueryAuth, accessToken);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, AuthInfoResp.class, new Object[0]);
        log.info("apiQueryAuth result={}", response.getBody());
        AuthInfoResp result = (AuthInfoResp)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public AuthorizerInfoResp apiGetAuthorizerInfo(@NonNull String accessToken, @NonNull String componetAppId, @NonNull String authorierAppId) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (componetAppId == null) {
            throw new NullPointerException("componetAppId is marked non-null but is null");
        }
        if (authorierAppId == null) {
            throw new NullPointerException("authorierAppId is marked non-null but is null");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("component_appid", componetAppId);
        params.put("authorizer_appid", authorierAppId);
        String url = MessageFormat.format(this.wxComponentApiGetAuthorizerInfo, accessToken);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, AuthorizerInfoResp.class, new Object[0]);
        AuthorizerInfoResp result = (AuthorizerInfoResp)response.getBody();
        log.info("apiGetAuthorizerInfo with result={}", (Object)result);
        WeixinException.isSuccess(result);
        return result;
    }

    public AuthorizerToken refreshAuthorizerToken(@NonNull String accessToken, @NonNull String componentAppId, @NonNull String authAppId, @NonNull String refreshToken) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (componentAppId == null) {
            throw new NullPointerException("componentAppId is marked non-null but is null");
        }
        if (authAppId == null) {
            throw new NullPointerException("authAppId is marked non-null but is null");
        }
        if (refreshToken == null) {
            throw new NullPointerException("refreshToken is marked non-null but is null");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("component_appid", componentAppId);
        params.put("authorizer_appid", authAppId);
        params.put("authorizer_refresh_token", refreshToken);
        String url = MessageFormat.format(this.wxComponentApiAuthorizerToken, accessToken);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, AuthorizerToken.class, new Object[0]);
        AuthorizerToken result = (AuthorizerToken)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public AuthorizerOption getAuthorizerOption(@NonNull String accessToken, @NonNull String componentId, @NonNull String authorizerAppId, @NonNull String optionName) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (componentId == null) {
            throw new NullPointerException("componentId is marked non-null but is null");
        }
        if (authorizerAppId == null) {
            throw new NullPointerException("authorizerAppId is marked non-null but is null");
        }
        if (optionName == null) {
            throw new NullPointerException("optionName is marked non-null but is null");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("component_appid", componentId);
        params.put("authorizer_appid", authorizerAppId);
        params.put("option_name", optionName);
        String url = MessageFormat.format(this.wxComponentApiGetAuthorizerOption, accessToken);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, AuthorizerOption.class, new Object[0]);
        AuthorizerOption result = (AuthorizerOption)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public void setAuthorizerOption(@NonNull String accessToken, @NonNull String componentId, @NonNull String authorizerAppId, @NonNull String optionName, @NonNull String optionValue) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (componentId == null) {
            throw new NullPointerException("componentId is marked non-null but is null");
        }
        if (authorizerAppId == null) {
            throw new NullPointerException("authorizerAppId is marked non-null but is null");
        }
        if (optionName == null) {
            throw new NullPointerException("optionName is marked non-null but is null");
        }
        if (optionValue == null) {
            throw new NullPointerException("optionValue is marked non-null but is null");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("component_appid", componentId);
        params.put("authorizer_appid", authorizerAppId);
        params.put("option_name", optionName);
        params.put("option_value", optionValue);
        String url = MessageFormat.format(this.wxComponentApiSetAuthorizerOption, accessToken);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)response.getBody();
        WeixinException.isSuccess(result);
    }
}

