/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api.applet;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.Add2TemplateReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.TemplateIdReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.TemplateDraftListResp;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.TemplateListResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.google.common.base.Preconditions;
import java.text.MessageFormat;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class AppletTemplateAPI {
    private static final Logger log = LoggerFactory.getLogger(AppletTemplateAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.applet.template.manager.draft_list}")
    private String appletTemplateDraftListUrl;
    @Value(value="${wx.applet.template.manager.add2Template}")
    private String appletTemplateAdd2TemplateUrl;
    @Value(value="${wx.applet.template.manager.get}")
    private String appletTemplateGetUrl;
    @Value(value="${wx.applet.template.manager.delete}")
    private String appletTemplateDeleteUrl;

    public TemplateDraftListResp getDraftList(@NonNull String accessToken) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("getDraftList");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        String url = MessageFormat.format(this.appletTemplateDraftListUrl, accessToken);
        resp = this.restTemplate.getForEntity(url, TemplateDraftListResp.class, new Object[0]);
        TemplateDraftListResp result = (TemplateDraftListResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public ErrorCode add2Template(@NonNull String accessToken, @NonNull Add2TemplateReq req) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        log.info("add2Template with req={}", (Object)req);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(req), (Object)"req\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.appletTemplateAdd2TemplateUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public TemplateListResp getTemplate(@NonNull String accessToken, Integer templateType) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("getTemplate with templateType={}", (Object)templateType);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        String url = MessageFormat.format(this.appletTemplateGetUrl, accessToken);
        resp = this.restTemplate.getForEntity(url, TemplateListResp.class, new Object[]{templateType});
        TemplateListResp result = (TemplateListResp)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public ErrorCode delTemplate(@NonNull String accessToken, Integer templateType) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        log.info("delTemplate with templateType={}", (Object)templateType);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken}), (Object)"accessToken\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((templateType != null ? 1 : 0) != 0, (Object)"templateType\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseEntity resp = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        TemplateIdReq req = new TemplateIdReq();
        req.setTemplateId(templateType);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = MessageFormat.format(this.appletTemplateDeleteUrl, accessToken);
        resp = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }
}

