/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.sdk.api;

import cn.kinyun.scrm.weixin.sdk.entity.basic.AccessToken;
import cn.kinyun.scrm.weixin.sdk.entity.basic.Ticket;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import java.text.MessageFormat;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class WxBasicAPI {
    private static final Logger log = LoggerFactory.getLogger(WxBasicAPI.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${wx.token.get}")
    private String wxTokenGet;
    @Value(value="${wx.ticket.getticket}")
    private String wxTicketGet;

    public AccessToken getAccessToken(@NonNull String appId, @NonNull String appSecret) throws WeixinException {
        if (appId == null) {
            throw new NullPointerException("appId is marked non-null but is null");
        }
        if (appSecret == null) {
            throw new NullPointerException("appSecret is marked non-null but is null");
        }
        log.info("get access_token for appid={}", (Object)appId);
        String url = MessageFormat.format(this.wxTokenGet, appId, appSecret);
        ResponseEntity response = this.restTemplate.getForEntity(url, AccessToken.class, new Object[0]);
        AccessToken result = (AccessToken)response.getBody();
        WeixinException.isSuccess(result);
        return result;
    }

    public Ticket getTicket(@NonNull String accessToken, @NonNull String type) throws WeixinException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        log.info("get ticket with type={}", (Object)type);
        String url = MessageFormat.format(this.wxTicketGet, accessToken, type);
        ResponseEntity response = this.restTemplate.getForEntity(url, Ticket.class, new Object[0]);
        Ticket ticket = (Ticket)response.getBody();
        WeixinException.isSuccess(ticket);
        return ticket;
    }
}

