/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.enums.template;

/**
 * 微信行业代码
 * 
 * @title WxIndustryCode
 * @desc 微信行业代码
 * @author yanmaoyuan
 * @date 2019年4月28日
 * @version 1.0
 * @see <a href="https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1433751277">行业代码查询</a>
 */
public enum WxIndustryCode {

    IT_WEB("IT科技", "互联网/电子商务", "1"),
    IT_SOFTWARE_AND_SERVICE("IT科技", "IT软件与服务", "2"),
    IT_HARDWARE_AND_DEVICE("IT科技", "IT硬件与设备", "3"),
    IT_ELECTRONIC_TECHNOLOGY("IT科技", "电子技术", "4"),
    IT_COMMUNICATION("IT科技", "通信与运营商", "5"),
    IT_GAME("IT科技", "网络游戏", "6"),
    FINANCIAL_BANK("金融业", "银行", "7"),
    FINANCIAL_FUND("金融业", "基金理财信托", "8"),
    FINANCIAL_INSURANCE("金融业", "保险", "9"),
    FOOD("餐饮", "餐饮", "10"),
    HOTEL("酒店旅游", "酒店", "11"),
    TOURISM("酒店旅游", "旅游", "12"),
    TRANSPORT_EXPRESS("运输与仓储", "快递", "13"),
    TRANSPORT_LOGISTICS("运输与仓储", "物流", "14"),
    TRANSPORT_STORAGE("运输与仓储", "仓储", "15"),
    EDU_TRAINING("教育", "培训", "16"),
    EDU_COLLEGE("教育", "院校", "17"),
    GOV_RESEARCH("政府与公共事业", "学术科研", "18"),
    GOV_TRAFFIC_POLICE("政府与公共事业", "交警", "19"),
    GOV_MUSEUM("政府与公共事业", "博物馆", "20"),
    GOV_NPO("政府与公共事业", "公共事业非盈利机构", "21"),
    MEDICINE("医药护理", "医药医疗", "22"),
    COSMETOLOGY("医药护理", "护理美容", "23"),
    HEALTHCARE("医药护理", "保健与卫生", "24"),
    VEHICLE_CAR("交通工具", "汽车相关", "25"),
    VEHICLE_MOTOR("交通工具", "摩托车相关", "26"),
    VEHICLE_TRAIN("交通工具", "火车相关", "27"),
    VEHICLE_AIRPLANE("交通工具", "飞机相关", "28"),
    REAL_ESTATE_CONSTRUCT("房地产", "建筑", "29"),
    REAL_ESTATE_PROPERTY("房地产", "物业", "30"),
    GOODS("消费品", "消费品", "31"),
    COMMERCIAL_LAW("商业服务", "法律", "32"),
    COMMERCIAL_EXHIBITION("商业服务", "会展", "33"),
    COMMERCIAL_INTERMEDIARY("商业服务", "中介服务", "34"),
    COMMERCIAL_CERTIFICATION("商业服务", "认证", "35"),
    COMMERCIAL_AUDIT("商业服务", "审计", "36"),
    ENTERTAINMENT_MEDIA("文体娱乐", "传媒", "37"),
    ENTERTAINMENT_SPORT("文体娱乐", "体育", "38"),
    ENTERTAINMENT("文体娱乐", "娱乐休闲", "39"),
    PRINT("印刷", "印刷", "40"),
    OTHER("其它", "其它", "41");
    ;
 
    // 编码
    private String code;

    // 主行业
    private String firstClass;

    // 副行业
    private String secondClass;

    /**
     * @param firstClass
     * @param secondClass
     * @param code
     */
    private WxIndustryCode(String firstClass, String secondClass, String code) {
        this.code = code;
        this.firstClass = firstClass;
        this.secondClass = secondClass;
    }

    /**
     * @return the code
     */
    public String getCode() {
        return code;
    }

    /**
     * @return the firstClass
     */
    public String getFirstClass() {
        return firstClass;
    }

    /**
     * @return the secondClass
     */
    public String getSecondClass() {
        return secondClass;
    }

}