package cn.kinyun.scrm.weixin.sdk.enums.component;

import java.util.HashMap;
import java.util.Map;

/**
 * @author : shanyu
 * @version V1.0
 * @Project: weixin-platform
 * @Package com.kuaike.weixin.component.api.enums
 * @Description: 消息推送类型
 * @date Date : 2019年04月24日 18:45
 */
@SuppressWarnings("squid:S115")
public enum InfoType {

    component_verify_ticket("component_verify_ticket", "ticket推送消息"),
    authorized("authorized", "授权成功通知"),
    unauthorized("unauthorized", "取消授权通知"),
    updateauthorized("updateauthorized", "授权更新通知"),
    notify_third_fastregister("notify_third_fasteregister","快速注册小程序审核通知"),
    ;

    private static final Map<String, InfoType> cache = new HashMap<>();

    static {
        for (InfoType e : values()) {
            cache.put(e.getType(), e);
        }
    }

    public static final InfoType get(String type) {
        return cache.get(type);
    }

    /**
     * 消息类型
     */
    private String type;

    /**
     * 描述
     */
    private String desc;

    public String getType(){
        return type;
    }

    public String getDesc(){
        return  desc;
    }

    private InfoType(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }
}
