/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 微信事件类型
 *
 * @author yanmaoyuan
 * @version 1.0
 * @title WxEventType
 * @desc 微信事件类型
 * @date 2019年4月24日
 */
public enum WxEventType {

    /**
     * 订阅
     */
    SUBSCRIBE("subscribe"),

    /**
     * 取消订阅
     */
    UNSUBSCRIBE("unsubscribe"),

    /**
     * 已关注用户扫描带参数二维码
     */
    SCAN("SCAN"),

    /**
     * 上报地理位置
     */
    LOCATION("LOCATION"),

    /**
     * 点击自定义菜单
     */
    CLICK("CLICK"),

    /**
     * 查看菜单
     */
    VIEW("VIEW"),

    /**
     * 查看小程序
     */
    VIEW_MINI_PROGRAM("view_miniprogram"),

    /**
     * 扫码推事件
     */
    SCAN_CODE_PUSH("scancode_push"),

    /**
     * 扫码推事件
     */
    SCAN_CODE_WAIT_MSG("scancode_waitmsg"),

    /**
     * 弹出系统拍照发图的事件
     */
    PIC_SYS_PHOTO("pic_sysphoto"),

    /**
     * 弹出拍照或者相册发图的事件
     */
    PIC_PHOTO_OR_ALBUM("pic_photo_or_album"),

    /**
     * 弹出微信相册发图器的事件
     */
    PIC_WEIXIN("pic_weixin"),

    /**
     * 弹出地理位置选择器的事件
     */
    LOCATION_SELECT("location_select"),

    /**
     * 事件推送-群发结果
     *
     * @see <a href="https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1481187827_i0l21">事件推送群发结果</a>
     */
    MASS_SEND_JOB_FINISH("MASSSENDJOBFINISH"),

    /**
     * 事件推送-模板消息发送结果
     *
     * @see <a href="https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1433751277">事件推送-模板消息发送结果</a>
     */
    TEMPLATE_SEND_JOB_FINISH("TEMPLATESENDJOBFINISH"),

    /**
     * 小商店商品审核结果
     */
    SHOP_PRODUCT_SPU_AUDIT("product_spu_audit"),

    /**
     * 小商店商品上架
     */
    SHOP_PRODUCT_SPU_LISTING("product_spu_listing"),

    /**
     * 小商店 订单update事件
     */
    SHOP_ORDER_UPDATE("product_order_status_update"),

    /**
     * 小商店 售后事件
     */
    SHOP_AFTER_SALE_UPDATE("product_after_sale_status"),

    /**
     * 小商店商品更新
     */
    SHOP_PRODUCT_SPU_UPDATE("product_spu_update"),

    /**
     * 小程序代码审核通过
     */
    WEAPP_AUDIT_SUCCESS("weapp_audit_success"),

    /**
     * 小程序代码审核不通过
     */
    WEAPP_AUDIT_FAIL("weapp_audit_fail"),

    /**
     * 小程序审核延后
     */
    WEAPP_AUDIT_DELAY("weapp_audit_delay"),

    /**
     * 小程序名称审核结果事件推送
     */
    WXA_NICKNAME_AUDIT("wxa_nickname_audit"),

    /**
     * 小程序类目审核结果事件推送
     */
    WXA_CATEGORY_AUDIT("wxa_category_audit")



    ;

    private static final Map<String, WxEventType> cache = new HashMap<>();

    static {
        for (WxEventType e : values()) {
            cache.put(e.getValue(), e);
        }
    }

    public static WxEventType get(String value) {
        return cache.get(value);
    }

    private String value = "";

    private WxEventType(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }
}