/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.template;

import com.fasterxml.jackson.annotation.JsonProperty;
import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;

import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 模板列表
 * 
 * @title PrivateTemplateList
 * @desc 模板列表
 * @author yanmaoyuan
 * @date 2019年4月29日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class PrivateTemplateList extends ErrorCode {

    private static final long serialVersionUID = -936437722781116626L;

    @JsonProperty("template_list")
    private List<PrivateTemplate> list;
}