/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.template;

import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import com.fasterxml.jackson.annotation.JsonProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 微信消息模板
 * 
 * @title PrivateTemplate
 * @desc 微信消息模板
 * @author yanmaoyuan
 * @date 2019年4月28日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class PrivateTemplate extends ErrorCode {

    private static final long serialVersionUID = -3835231757728421153L;

    /**
     * 模板ID
     */
    @JsonProperty("template_id")
    private String templateId;

    /**
     * 模板标题
     */
    private String title;

    /**
     * 模板所属行业的一级行业
     */
    @JsonProperty("primary_industry")
    private String primaryIndustry;

    /**
     * 模板所属行业的二级行业
     */
    @JsonProperty("deputy_industry")
    private String deputyIndustry;

    /**
     * 模板内容
     */
    private String content;

    /**
     * 模板示例
     */
    private String example;
}