/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.sns;

import com.fasterxml.jackson.annotation.JsonProperty;
import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;

import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 网页授权后可以获得的用户信息
 * 
 * @title SnsUserinfo
 * @desc 微信用户信息
 * @author yanmaoyuan
 * @date 2019年4月22日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class SnsUserinfo extends ErrorCode {

    private static final long serialVersionUID = 8968142111723596453L;

    /**
     * 普通用户的标识，对当前开发者帐号唯一
     */
    @JsonProperty("openid")
    private String openId;

    /**
     * 普通用户昵称
     */
    private String nickname;

    /**
     * 普通用户性别，1为男性，2为女性
     */
    private Integer sex;

    /**
     * 普通用户个人资料填写的省份
     */
    private String province;
    
    /**
     * 普通用户个人资料填写的城市
     */
    private String city;
    
    /**
     * 国家，如中国为CN
     */
    private String country;
    
    /**
     * 用户头像，最后一个数值代表正方形头像大小（有0、46、64、96、132数值可选，0代表640*640正方形头像），用户没有头像时该项为空
     */
    @JsonProperty("headimgurl")
    private String headImgUrl;
    
    /**
     * 用户特权信息，json数组，如微信沃卡用户为（chinaunicom）
     */
    private List<String> privilege;
    
    /**
     * 用户统一标识。针对一个微信开放平台帐号下的应用，同一用户的unionid是唯一的。
     */
    @JsonProperty("unionid")
    private String unionId;
}