package cn.kinyun.scrm.weixin.sdk.entity.shop.req;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @Desc
 * @Author zhangjing
 * @Date 2021/12/31 6:03 下午
 * @Version 1.0
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class SpuProductIdReq {

    /**
     * 小商店内部商品ID，与out_product_id二选一
     */
    @JsonProperty("product_id")
    protected Long productId;

    /**
     * 商家自定义商品ID，与product_id二选一
     */
    @JsonProperty("out_product_id")
    protected String outProductId;

    public void validate() {
        Preconditions.checkArgument(StringUtils.isNotBlank(outProductId) || Objects.nonNull(productId), "productId和outProductId不能同时为空");
    }
}
