package cn.kinyun.scrm.weixin.sdk.entity.shop.req;

import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.AttrItem;
import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author zhangjing
 * @date 2022/1/4 11:22 上午
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class SkuAddReq {
    /**
     * 小商店内部商品ID，与out_product_id二选一
     */
    @JsonProperty("product_id")
    protected Long productId;

    /**
     * 商家自定义商品ID，与out_product_id二选一
     */
    @JsonProperty("out_product_id")
    protected String outProductId;

    /**
     * 必填, 商家自定义sku_id，需要自行保证单appid内唯一，一旦添加成功后该字段无法修改，最
     */
    @JsonProperty("out_sku_id")
    protected String outSkuId;

    /**
     * 非必填, sku小图
     */
    @JsonProperty("thumb_img")
    protected String thumbImg;

    /**
     * 必填, 售卖价格,以分为单位，不超过1000000000（1000万元）
     */
    @JsonProperty("sale_price")
    protected Long salePrice;

    /**
     * 非必填, 市场价格,以分为单位，不超过1000000000（1000万元），必须比sale_price大
     */
    @JsonProperty("market_price")
    protected Long marketPrice;

    /**
     * 必填, 库存
     */
    @JsonProperty("stock_num")
    protected Long stockNum;

    /**
     * 非必填, 商品编码,最多20个字符
     */
    @JsonProperty("sku_code")
    protected String skuCode;

    /**
     * 非必填, 条形码
     */
    @JsonProperty("barcode")
    protected String barCode;

    /**
     * 商品属性
     */
    @JsonProperty("sku_attrs")
    protected List<AttrItem> skuAttrs;

}
