package cn.kinyun.scrm.weixin.sdk.entity.shop.dto.address;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Desc
 * @Author zhangjing
 * @Date 2021/12/30 7:53 下午
 * @Version 1.0
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class AddressInfo {

    /**
     * 收货人姓名
     */
    @JsonProperty("user_name")
    private String userName;

    /**
     * 邮政编码
     */
    @JsonProperty("postal_code")
    private String postalCode;

    /**
     * 省份，格式：广东省 北京市
     */
    @JsonProperty("province_name")
    private String provinceName;

    /**
     * 城市，格式：广州市
     */
    @JsonProperty("city_name")
    private String cityName;

    /**
     * 区，格式：海珠区
     */
    @JsonProperty("county_name")
    private String countyName;

    /**
     * 详细地址
     */
    @JsonProperty("detail_info")
    private String detailInfo;

    /**
     * 	国家码
     */
    @JsonProperty("national_code")
    private Integer nationalCode;

    /**
     * 电话号
     */
    @JsonProperty("tel_number")
    private String telNumber;

    /**
     * 经度
     */
    private Double lat;

    /**
     * 维度
     */
    private Double lng;

    /**
     * 门牌号
     */
    @JsonProperty("house_number")
    private String houseNumber;
}
