package cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * @author zhangjing
 * @desc
 * @date 2022/1/26 4:02 下午
 */
@Data
public class JsCode2SessionReq {

    /**
     * 小程序appId
     */
    @JsonProperty("appid")
    private String appId;

    /**
     * 登录时获取的 code
     */
    @JsonProperty("js_code")
    private String jsCode;

    /**
     * 第三方平台 appid
     */
    @JsonProperty("component_appid")
    private String componentAppId;

    /**
     * 第三方平台的component_access_token
     */
    @JsonProperty("component_access_token")
    private String componentAccessToken;

    public void validate() {
        Preconditions.checkArgument(StringUtils.isNotBlank(appId), "appId不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(jsCode), "jsCode不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(componentAppId), "componentAppId不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(componentAccessToken), "componentAccessToken不能为空");
    }
}
