package cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * @author zhangjing
 * @desc
 * @date 2022/1/18 10:37 上午
 */
@Data
public class CommitCodeReq {

    /**
     * 必填, 代码库中的代码模板ID
     */
    @JsonProperty("template_id")
    private String templateId;

    /**
     * 必填, 为了方便第三方平台的开发者引入 extAppid 的开发调试工作，引入ext.json配置文件概念，该参数则是用于控制ext.json配置文件的内容
     */
    @JsonProperty("ext_json")
    private String extJson;

    /**
     * 必填, 代码版本号，开发者可自定义（长度不要超过 64 个字符）
     */
    @JsonProperty("user_version")
    private String userVersion;

    /**
     * 必填, 代码描述，开发者可自定义
     */
    @JsonProperty("user_desc")
    private String userDesc;

}
