package cn.kinyun.scrm.weixin.sdk.entity.miniprogram.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * @author Created by chenjiaqiang on 2024/03/07
 **/
@Data
public class PrivacyOwnerSettingDto {

    /**
     * 信息收集方（开发者）的手机号，4种联系方式至少要填一种
     */
    @JsonProperty("contact_phone")
    private String contactPhone;

    /**
     * 信息收集方（开发者）的邮箱地址，4种联系方式至少要填一种
     */
    @JsonProperty("contact_email")
    private String contactEmail;

    /**
     * 信息收集方（开发者）的qq号，4种联系方式至少要填一种
     */
    @JsonProperty("contact_qq")
    private String contactQq;

    /**
     * 信息收集方（开发者）的微信号，4种联系方式至少要填一种
     */
    @JsonProperty("contact_weixin")
    private String contactWeixin;

    /**
     * 存储期限，指的是开发者收集用户信息存储多久。如果不填则展示为【开发者承诺，除法律法规另有规定，开发者对你的信息保存期限应当为实现处理目的所必要的最短时间】，如果填请填数字+天，例如“30天”，否则会出现87072的报错。
     */
    @JsonProperty("store_expire_timestamp")
    private String storeExpireTimestamp;

    /**
     * 如果开发者不使用微信提供的标准化用户隐私保护指引模板，也可以上传自定义的用户隐私保护指引，通过uploadPrivacySetting接口上传后可获取media_id
     */
    @JsonProperty("ext_file_media_id")
    private String extFileMediaId;

    /**
     * 通知方式，指的是当开发者收集信息有变动时，通过该方式通知用户。这里服务商需要按照实际情况填写，例如通过弹窗或者公告或者其他方式。
     */
    @JsonProperty("notice_method")
    private String noticeMethod;

    /**
     * 存储地区；境外主体小程序需要补充「用户隐私保护指引」中「存储地区」的相关信息，否则小程序审核会被驳回。
     */
    @JsonProperty("store_region")
    private Integer storeRegion;

}
