/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.message.resp;

import cn.kinyun.scrm.weixin.sdk.enums.WxMsgType;
import com.fasterxml.jackson.annotation.JsonProperty;
import cn.kinyun.scrm.weixin.sdk.utils.MsgXmlBuilder;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 回复语音消息
 * 
 * @title VoiceMsg
 * @desc 回复语音消息
 * @author yanmaoyuan
 * @date 2019年4月25日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class VoiceMsg extends BaseRespMsg {

    private static final long serialVersionUID = -7345932706455809373L;

    /**
     * 通过素材管理中的接口上传多媒体文件，得到的id。
     */
    @JsonProperty("media_id")
    private String mediaId;

    public VoiceMsg() {
        this.msgType = WxMsgType.Voice.getValue();
    }

    @Override
    public String toXml() {
        MsgXmlBuilder builder = new MsgXmlBuilder(super.toXml());

        builder.append("<Voice>");
        builder.addCData("MediaId", mediaId);
        builder.append("</Voice>");
        builder.surroundWith("xml");

        return builder.toString();
    }

}