/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.message.resp;

import cn.kinyun.scrm.weixin.sdk.enums.WxMsgType;
import com.fasterxml.jackson.annotation.JsonProperty;
import cn.kinyun.scrm.weixin.sdk.utils.MsgXmlBuilder;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 回复视频消息
 * 
 * @title VideoMsg
 * @desc 回复视频消息
 * @author yanmaoyuan
 * @date 2019年4月25日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class VideoMsg extends BaseRespMsg {

    private static final long serialVersionUID = 5172576960752149860L;

    /**
     * 视频消息的标题
     */
    private String title;

    /**
     * 视频消息的描述
     */
    private String description;

    /**
     * 通过素材管理中的接口上传多媒体文件，得到的id
     */
    @JsonProperty("media_id")
    private String mediaId;

    /**
     * 缩略图的媒体id，通过素材管理中的接口上传多媒体文件，得到的id。
     * 
     * 在客服消息中会使用到，XML消息不会使用。
     */
    @JsonProperty("thumb_media_id")
    private String thumbMediaId;

    public VideoMsg() {
        this.msgType = WxMsgType.Video.getValue();
    }

    @Override
    public String toXml() {
        MsgXmlBuilder builder = new MsgXmlBuilder(super.toXml());

        builder.append("<Video>");
        builder.addCData("MediaId", mediaId);
        builder.addCData("Title", title);
        builder.addCData("Description", description);
        builder.append("</Video>");
        builder.surroundWith("xml");

        return builder.toString();
    }

}