/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.message.resp;

import cn.kinyun.scrm.weixin.sdk.enums.WxMsgType;
import com.fasterxml.jackson.annotation.JsonProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 上传到微信的群发视频素材
 * 
 * @title MpVideoMsg
 * @desc 上传到微信的群发视频素材
 * @author yanmaoyuan
 * @date 2019年4月28日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class MpVideoMsg extends BaseRespMsg {

    private static final long serialVersionUID = 6548435629370131346L;

    /**
     * 图片素材ID
     */
    @JsonProperty("media_id")
    private String mediaId;

    public MpVideoMsg() {
        this.msgType = WxMsgType.MpVideo.getValue();
    }

    @Override
    public String toXml() {
        throw new UnsupportedOperationException("此类消息不支持以XML格式回复给用户");
    }
}