/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.message.resp;

import cn.kinyun.scrm.weixin.sdk.enums.WxMsgType;
import com.fasterxml.jackson.annotation.JsonProperty;
import cn.kinyun.scrm.weixin.sdk.utils.MsgXmlBuilder;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 回复图片消息
 * 
 * @title ImageMsg
 * @desc 回复图片消息
 * @author yanmaoyuan
 * @date 2019年4月25日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ImageMsg extends BaseRespMsg {

    private static final long serialVersionUID = -2235241806858208855L;

    /**
     * 通过素材管理中的接口上传多媒体文件，得到的id。
     */
    @JsonProperty("media_id")
    private String mediaId;

    public ImageMsg() {
        this.msgType = WxMsgType.Image.getValue();
    }

    @Override
    public String toXml() {
        MsgXmlBuilder builder = new MsgXmlBuilder(super.toXml());

        builder.append("<Image>");
        builder.addCData("MediaId", getMediaId());
        builder.append("</Image>");
        builder.surroundWith("xml");

        return builder.toString();
    }

}