package cn.kinyun.scrm.weixin.sdk.entity.material.resp;

import com.fasterxml.jackson.annotation.JsonProperty;
import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @ClassName GetMaterialCountResp
 * @Description
 * @Author zhangjing
 * @DATE 2019/4/29 15:29
 * @Version 1.0
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ToString(callSuper=true)
public class GetMaterialCountResp extends ErrorCode {

    private static final long serialVersionUID = 4913954514733696691L;
    /**
     * 语音总数量
     */
    @JsonProperty("voice_count")
    Integer voiceCount;

    /**
     * 视频总数量
     */
    @JsonProperty("video_count")
    Integer videoCount;

    /**
     * 图片总数量
     */
    @JsonProperty("image_count")
    Integer imageCount;

    /**
     * 图文总数量
     */
    @JsonProperty("news_count")
    Integer newsCount;
}
