/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.custom;

import com.fasterxml.jackson.annotation.JsonProperty;
import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;

import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 未接入会话列表
 * 
 * @title WaitCaseList
 * @desc 未接入会话列表
 * @author yanmaoyuan
 * @date 2019年5月5日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class WaitCaseList extends ErrorCode {

    private static final long serialVersionUID = 8566305888255469931L;

    /**
     * 未接入会话数量
     */
    private int count;
    
    /**
     * 未接入会话列表，最多返回100条数据，按照来访顺序
     */
    @JsonProperty("waitcaselist")
    private List<WaitCase> list;
}
