/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.custom;

import com.fasterxml.jackson.annotation.JsonProperty;
import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 客服人员
 * 
 * @title Servant
 * @desc 客服人员
 * @author yanmaoyuan
 * @date 2019年5月5日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class Servant extends ErrorCode {

    private static final long serialVersionUID = -2351298308378394637L;

    /**
     * 正在接待的客服，为空表示没有人在接待
     */
    @JsonProperty("kf_account")
    private String kfAccount;
    
    /**
     * 会话接入的时间，unix时间戳，单位：秒
     */
    @JsonProperty("createtime")
    private long createTime;
}