/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.custom;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

import lombok.Data;

/**
 * 在线客服
 * 
 * @title OnlineCustomAccount
 * @desc 在线客服
 * @author yanmaoyuan
 * @date 2019年4月30日
 * @version 1.0
 */
@Data
public class OnlineCustomAccount implements Serializable {

    private static final long serialVersionUID = 3309495055314469309L;

    /**
     * 客服工号
     */
    @JsonProperty("kf_id")
    private String id;

    /**
     * 完整客服账号，格式为：账号前缀@公众号微信号
     */
    @JsonProperty("kf_account")
    private String account;

    /**
     * 客服在线状态，目前为：1、web 在线
     */
    private int status;

    /**
     * 客服当前正在接待的会话数
     */
    @JsonProperty("accepted_case")
    private int acceptedCase;
    
}