/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.analysis.user;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * @title UserCumulateDto
 * @author yanmaoyuan
 * @date 2019年9月25日
 * @version 1.0
 */
@Data
public class UserCumulateDto implements Serializable {

    private static final long serialVersionUID = 8001004155722268301L;

    /**
     * 数据的日期
     */
    @JsonAlias("ref_date")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date refDate;

    /**
     * 用户的渠道，数值代表的含义如下：
     * <pre>
     * 0 代表其他合计 
     * 1 代表公众号搜索
     * 17 代表名片分享
     * 30 代表扫描二维码
     * 43 代表图文页右上角菜单
     * 51 代表支付后关注（在支付完成页）
     * 57 代表图文页内公众号名称
     * 75 代表公众号文章广告
     * 78 代表朋友圈广告
     * </pre>
     */
    @JsonAlias("cumulate_user")
    private int cumulateUser;
}