package cn.kinyun.scrm.weixin.sdk.api.shop;

import cn.kinyun.scrm.weixin.sdk.entity.shop.req.AddressGetReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.AddressGetResp;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import com.google.common.base.Preconditions;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.text.MessageFormat;
import java.util.Objects;

/**
 * @author zhangjing
 * @desc
 * @date 2022/1/10 7:55 下午
 */
@Slf4j
@Component
public class WxShopAddressAPI {

    @Autowired
    private RestTemplate restTemplate;

    /**
     * 商家地址管理接口-获取商家地址 POST
     */
    @Value("${wx.shop.address.get}")
    private String shopGetAddressUrl;

    /**
     * 获取商家地址
     *
     * @param accessToken
     * @param req
     * @return
     */
    public AddressGetResp getAddress(@NonNull String accessToken, @NonNull AddressGetReq req) {
        log.info("getAddress with req={}", req);

        Preconditions.checkArgument(StringUtils.isNoneBlank(accessToken), "accessToken不能为空");
        Preconditions.checkArgument(Objects.nonNull(req), "req不能为空");

        ResponseEntity<AddressGetResp> resp = null;

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        // 构造请求体
        HttpEntity<AddressGetReq> httpEntity = new HttpEntity<>(req, headers);

        // 发送请求
        String url = MessageFormat.format(shopGetAddressUrl, accessToken);
        resp = restTemplate.postForEntity(url, httpEntity, AddressGetResp.class);

        AddressGetResp result = resp.getBody();
        WeixinException.isSuccess(result);
        return result;
    }
}
